/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.libsparklines;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.libraries.libsparklines.util.GraphUtils;

public class LineGraphDrawable {
    private static final int DEFAULT_SPACING = 2;
    private static final Number[] EMPTY = new Number[0];
    private static final float LAST_POINT_RADIUS = 2.5f;
    private static final float LAST_POINT_DIAMETER = 5.0f;
    private int spacing = 2;
    private Color color = Color.black;
    private Color background;
    private Color lastColor;
    private Number[] data = EMPTY;

    public Number[] getData() {
        return (Number[])this.data.clone();
    }

    public void setData(Number[] data) {
        this.data = (Number[])data.clone();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.color = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public Color getLastColor() {
        return this.lastColor;
    }

    public void setLastColor(Color lastColor) {
        this.lastColor = lastColor;
    }

    public void draw(Graphics2D graphics, Rectangle2D drawArea) {
        float lastPointRadius;
        float lastPointDiameter;
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (drawArea == null) {
            throw new NullPointerException();
        }
        if (this.lastColor == null) {
            lastPointDiameter = 0.0f;
            lastPointRadius = 0.0f;
        } else {
            lastPointDiameter = 5.0f;
            lastPointRadius = 2.5f;
        }
        int height = (int)(drawArea.getHeight() - (double)lastPointDiameter);
        if (height <= 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)graphics.create();
        if (this.background != null) {
            g2.setPaint(this.background);
            g2.draw(drawArea);
        }
        if (this.data.length == 0) {
            g2.dispose();
            return;
        }
        g2.translate(drawArea.getX(), drawArea.getY() + (double)lastPointRadius);
        float scale = GraphUtils.getDivisor(this.data, height);
        int spacing = this.getSpacing();
        float usableWidth = (float)(drawArea.getWidth() - (double)lastPointRadius);
        float width = (usableWidth - (float)(spacing * (this.data.length - 1))) / (float)(this.data.length - 1);
        float min = this.computeMin();
        int x = 0;
        int y = -1;
        if ((double)scale == 0.0) {
            scale = 1.0f;
            y = -height / 2;
        }
        double lastX = 0.0;
        double lastY = 0.0;
        Line2D.Double line = new Line2D.Double();
        g2.setPaint(this.color);
        for (int i = 0; i < this.data.length - 1; ++i) {
            int px1 = x;
            int px2 = x = (int)((float)x + (width + (float)spacing));
            Number number = this.data[i];
            Number nextNumber = this.data[i + 1];
            if (number == null && nextNumber == null) {
                float delta = (float)height - (0.0f - min) / scale;
                line.setLine(px1, (float)y + delta, px2, (float)y + delta);
            } else if (number == null) {
                line.setLine(px1, (float)y + ((float)height - (0.0f - min) / scale), px2, (float)y + ((float)height - (nextNumber.floatValue() - min) / scale));
            } else if (nextNumber == null) {
                line.setLine(px1, (float)y + ((float)height - (number.floatValue() - min) / scale), px2, (float)y + ((float)height - (0.0f - min) / scale));
            } else {
                line.setLine(px1, (float)y + ((float)height - (number.floatValue() - min) / scale), px2, (float)y + ((float)height - (nextNumber.floatValue() - min) / scale));
            }
            lastX = line.getX2();
            lastY = line.getY2();
            g2.draw(line);
        }
        if (this.lastColor != null) {
            g2.setColor(this.lastColor);
            g2.fill(new Ellipse2D.Double(lastX - 2.5, lastY - 2.5, 5.0, 5.0));
        }
        g2.dispose();
    }

    private float computeMin() {
        float min = Float.MAX_VALUE;
        for (int index = 0; index < this.data.length; ++index) {
            float value;
            Number i = this.data[index];
            if (i == null || !((value = i.floatValue()) < min)) continue;
            min = value;
        }
        return min;
    }
}

