/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class SparkConfigurationService
implements Service {
    private static XLog LOG = XLog.getLog(SparkConfigurationService.class);
    public static final String CONF_PREFIX = "oozie.service.SparkConfigurationService.";
    public static final String SPARK_CONFIGURATIONS = "oozie.service.SparkConfigurationService.spark.configurations";
    public static final String SPARK_CONFIGURATIONS_IGNORE_SPARK_YARN_JAR = "oozie.service.SparkConfigurationService.spark.configurations.ignore.spark.yarn.jar";
    public static final String SPARK_CONFIGURATIONS_BLACKLIST = "oozie.service.SparkConfigurationService.spark.configurations.blacklist";
    private static final String SPARK_CONFIG_FILE = "spark-defaults.conf";
    private static final String SPARK_YARN_JAR_PROP = "spark.yarn.jar";
    private static final String HOST_WILDCARD = "*";
    private Map<String, Properties> sparkConfigs;
    private Set<String> blacklist;

    @Override
    public void init(Services services) throws ServiceException {
        this.loadBlacklist();
        this.loadSparkConfigs();
    }

    @Override
    public void destroy() {
        this.sparkConfigs.clear();
        this.blacklist.clear();
    }

    @Override
    public Class<? extends Service> getInterface() {
        return SparkConfigurationService.class;
    }

    private void loadBlacklist() {
        this.blacklist = new HashSet<String>();
        for (String s : ConfigurationService.getStrings(SPARK_CONFIGURATIONS_BLACKLIST)) {
            this.blacklist.add(s.trim());
        }
        if (ConfigurationService.getBoolean(SPARK_CONFIGURATIONS_IGNORE_SPARK_YARN_JAR)) {
            LOG.warn("Deprecated property found in configuration: oozie.service.SparkConfigurationService.spark.configurations.ignore.spark.yarn.jarUse oozie.service.SparkConfigurationService.spark.configurations.blacklist instead.");
            this.blacklist.add(SPARK_YARN_JAR_PROP);
        }
    }

    private void loadSparkConfigs() throws ServiceException {
        String[] confDefs;
        this.sparkConfigs = new HashMap<String, Properties>();
        for (String confDef : confDefs = ConfigurationService.getStrings(SPARK_CONFIGURATIONS)) {
            this.readEntry(confDef.trim());
        }
    }

    private void readEntry(String confDef) throws ServiceException {
        String[] parts = confDef.split("=");
        if (parts.length == 2) {
            String hostPort = parts[0];
            String confDir = parts[1];
            File dir = this.getAbsoluteDir(confDir);
            if (dir.exists()) {
                Properties sparkDefaults = this.readSparkConfigFile(hostPort, dir);
                this.filterBlackList(sparkDefaults);
                if (!sparkDefaults.isEmpty()) {
                    this.sparkConfigs.put(hostPort, sparkDefaults);
                }
            } else {
                LOG.warn("Spark Configuration could not be loaded for {0}: {1} does not exist", hostPort, dir.getAbsolutePath());
            }
        } else {
            LOG.warn("Spark Configuration could not be loaded: invalid value found: {0}", confDef);
        }
    }

    private File getAbsoluteDir(String confDir) throws ServiceException {
        File dir = new File(confDir);
        if (!dir.isAbsolute()) {
            File configDir = new File(ConfigurationService.getConfigurationDirectory());
            dir = new File(configDir, confDir);
        }
        return dir;
    }

    private void filterBlackList(Properties sparkDefaults) {
        for (String property : this.blacklist) {
            sparkDefaults.remove(property);
        }
    }

    private Properties readSparkConfigFile(String hostPort, File dir) {
        File file = new File(dir, SPARK_CONFIG_FILE);
        Properties props = new Properties();
        if (file.exists()) {
            try (FileInputStream stream = new FileInputStream(file);
                 InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8.name());){
                props.load(reader);
                LOG.info("Loaded Spark Configuration: {0}={1}", hostPort, file.getAbsolutePath());
            }
            catch (IOException ioe) {
                LOG.warn("Spark Configuration could not be loaded for {0}: {1}", hostPort, ioe.getMessage(), ioe);
            }
        } else {
            LOG.warn("Spark Configuration could not be loaded for {0}: {1} does not exist", hostPort, file.getAbsolutePath());
        }
        return props;
    }

    public Properties getSparkConfig(String resourceManagerHostPort) {
        resourceManagerHostPort = resourceManagerHostPort != null ? resourceManagerHostPort.toLowerCase() : null;
        Properties config = this.sparkConfigs.get(resourceManagerHostPort);
        if (config == null && (config = this.sparkConfigs.get(HOST_WILDCARD)) == null) {
            config = new Properties();
        }
        return config;
    }
}

