/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.midi;

import java.util.HashMap;
import java.util.Map;

public class TrackTimeManager {
    private double[][] beatTime = new double[16][16];
    private byte currentTrackNumber = 0;
    private byte lastCreatedTrackNumber = 0;
    private byte[] currentLayerNumber = new byte[16];
    private double initialNoteBeatTimeForHarmonicNotes = 0.0;
    private Map<String, Double> bookmarkedTrackTimeMap = new HashMap<String, Double>();

    public void setCurrentTrack(byte trackNumber) {
        if (trackNumber > this.lastCreatedTrackNumber) {
            for (int i = this.lastCreatedTrackNumber + 1; i < trackNumber; ++i) {
                this.createTrack((byte)i);
            }
            this.lastCreatedTrackNumber = trackNumber;
        }
        this.currentTrackNumber = trackNumber;
    }

    public byte getCurrentTrackNumber() {
        return this.currentTrackNumber;
    }

    protected byte getLastCreatedTrackNumber() {
        return this.lastCreatedTrackNumber;
    }

    protected void createTrack(byte track) {
        for (int layer = 0; layer < 16; layer = (int)((byte)(layer + 1))) {
            this.beatTime[track][layer] = 0.0;
        }
        this.currentLayerNumber[track] = 0;
    }

    public void setCurrentLayerNumber(byte layerNumber) {
        this.currentLayerNumber[this.currentTrackNumber] = layerNumber;
    }

    protected byte getCurrentLayerNumber() {
        return this.currentLayerNumber[this.getCurrentTrackNumber()];
    }

    public void setInitialNoteBeatTimeForHarmonicNotes(double initialNoteBeatTimeForHarmonicNotes) {
        this.initialNoteBeatTimeForHarmonicNotes = initialNoteBeatTimeForHarmonicNotes;
    }

    public double getInitialNoteBeatTimeForHarmonicNotes() {
        return this.initialNoteBeatTimeForHarmonicNotes;
    }

    public void advanceTrackBeatTime(double advanceTime) {
        double[] dArray = this.beatTime[this.currentTrackNumber];
        byte by = this.currentLayerNumber[this.currentTrackNumber];
        dArray[by] = dArray[by] + advanceTime;
    }

    public void setTrackBeatTime(double newTime) {
        this.beatTime[this.currentTrackNumber][this.currentLayerNumber[this.currentTrackNumber]] = newTime;
    }

    public void setAllTrackBeatTime(double newTime) {
        for (int track = 0; track < 16; ++track) {
            for (int layer = 0; layer < 16; ++layer) {
                if (!(this.beatTime[track][layer] < newTime)) continue;
                this.beatTime[track][layer] = newTime;
            }
        }
    }

    public double getTrackBeatTime() {
        return this.beatTime[this.getCurrentTrackNumber()][this.getCurrentLayerNumber()];
    }

    public void addTrackTickTimeBookmark(String timeBookmarkID) {
        this.bookmarkedTrackTimeMap.put(timeBookmarkID, this.getTrackBeatTime());
    }

    public double getTrackBeatTimeBookmark(String timeBookmarkID) {
        return this.bookmarkedTrackTimeMap.get(timeBookmarkID);
    }

    public double getLatestTrackBeatTime(byte trackNumber) {
        double latestTime = 0.0;
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            if (!(this.beatTime[trackNumber][i] > latestTime)) continue;
            latestTime = this.beatTime[trackNumber][i];
        }
        return latestTime;
    }
}

