/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.jfugue.midi.MidiDictionary;
import org.jfugue.pattern.Token;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;
import org.staccato.Subparser;

public class TempoSubparser
implements Subparser {
    public static final char TEMPO = 'T';
    private static TempoSubparser instance;

    public static TempoSubparser getInstance() {
        if (instance == null) {
            instance = new TempoSubparser();
        }
        return instance;
    }

    @Override
    public boolean matches(String music) {
        return music.charAt(0) == 'T';
    }

    @Override
    public Token.TokenType getTokenType(String tokenString) {
        if (tokenString.charAt(0) == 'T') {
            return Token.TokenType.TEMPO;
        }
        return Token.TokenType.UNKNOWN_TOKEN;
    }

    @Override
    public int parse(String music, StaccatoParserContext context) {
        if (this.matches(music)) {
            int posNextSpace = StaccatoUtil.findNextOrEnd(music, ' ', 0);
            int tempo = -1;
            if (posNextSpace > 1) {
                String tempoId = music.substring(1, posNextSpace);
                if (tempoId.matches("\\d+")) {
                    tempo = Integer.parseInt(tempoId);
                } else {
                    if (tempoId.charAt(0) == '[') {
                        tempoId = tempoId.substring(1, tempoId.length() - 1);
                    }
                    tempo = (Integer)context.getDictionary().get(tempoId);
                }
            }
            context.getParser().fireTempoChanged(tempo);
            return posNextSpace + 1;
        }
        return 0;
    }

    public static void populateContext(StaccatoParserContext context) {
        context.getDictionary().putAll(MidiDictionary.TEMPO_STRING_TO_INT);
    }
}

