/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.jfugue.parser.ParserException;
import org.jfugue.pattern.Token;
import org.jfugue.provider.ChordProviderFactory;
import org.jfugue.provider.KeyProvider;
import org.jfugue.theory.Key;
import org.jfugue.theory.Note;
import org.jfugue.theory.Scale;
import org.jfugue.theory.TimeSignature;
import org.staccato.StaccatoMessages;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;
import org.staccato.Subparser;

public class SignatureSubparser
implements Subparser,
KeyProvider {
    public static final String KEY_SIGNATURE = "KEY:";
    public static final String TIME_SIGNATURE = "TIME:";
    public static final String SEPARATOR = "/";
    private static SignatureSubparser instance;
    public static final String[] MAJOR_KEY_SIGNATURES;
    public static final String[] MINOR_KEY_SIGNATURES;
    public static final int KEYSIG_MIDPOINT = 7;
    public static final String MAJOR_ABBR = "maj";
    public static final String MINOR_ABBR = "min";
    public static final char SHARP_CHAR = '#';
    public static final char FLAT_CHAR = 'B';

    public static SignatureSubparser getInstance() {
        if (instance == null) {
            instance = new SignatureSubparser();
        }
        return instance;
    }

    @Override
    public boolean matches(String music) {
        return this.matchesKeySignature(music) || this.matchesTimeSignature(music);
    }

    public boolean matchesKeySignature(String music) {
        return music.length() >= KEY_SIGNATURE.length() && music.substring(0, KEY_SIGNATURE.length()).equals(KEY_SIGNATURE);
    }

    public boolean matchesTimeSignature(String music) {
        return music.length() >= TIME_SIGNATURE.length() && music.substring(0, TIME_SIGNATURE.length()).equals(TIME_SIGNATURE);
    }

    @Override
    public Token.TokenType getTokenType(String tokenString) {
        if (this.matchesKeySignature(tokenString)) {
            return Token.TokenType.KEY_SIGNATURE;
        }
        if (this.matchesTimeSignature(tokenString)) {
            return Token.TokenType.TIME_SIGNATURE;
        }
        return Token.TokenType.UNKNOWN_TOKEN;
    }

    @Override
    public int parse(String music, StaccatoParserContext context) {
        if (this.matchesKeySignature(music)) {
            int posNextSpace = StaccatoUtil.findNextOrEnd(music, ' ', 0);
            Key key = this.createKey(music.substring(KEY_SIGNATURE.length(), posNextSpace));
            context.setKey(key);
            context.getParser().fireKeySignatureParsed(key.getRoot().getPositionInOctave(), key.getScale().getMajorOrMinorIndicator());
            return posNextSpace + 1;
        }
        if (this.matchesTimeSignature(music)) {
            int posNextSpace = StaccatoUtil.findNextOrEnd(music, ' ', 0);
            String timeString = music.substring(TIME_SIGNATURE.length(), posNextSpace);
            int posOfSlash = timeString.indexOf(SEPARATOR);
            if (posOfSlash == -1) {
                throw new ParserException(StaccatoMessages.NO_TIME_SIGNATURE_SEPARATOR, timeString);
            }
            byte numerator = Byte.parseByte(timeString.substring(0, posOfSlash));
            byte denominator = Byte.parseByte(timeString.substring(posOfSlash + 1, timeString.length()));
            TimeSignature timeSignature = new TimeSignature(numerator, denominator);
            context.setTimeSignature(timeSignature);
            context.getParser().fireTimeSignatureParsed(numerator, denominator);
            return posNextSpace + 1;
        }
        return 0;
    }

    @Override
    public Key createKey(String keySignature) {
        if (keySignature.charAt(0) == 'K' && (keySignature.indexOf(35) == 1 || keySignature.toUpperCase().indexOf(66) == 1)) {
            return this.createKeyFromAccidentals(keySignature);
        }
        return new Key(ChordProviderFactory.getChordProvider().createChord(keySignature));
    }

    public Key createKeyFromAccidentals(String keySignature) {
        return new Key(MAJOR_KEY_SIGNATURES[7 + this.countAccidentals(keySignature)] + MAJOR_ABBR);
    }

    private byte countAccidentals(String keySignatureAsFlatsOrSharps) {
        byte keySig = 0;
        for (char ch : keySignatureAsFlatsOrSharps.toUpperCase().toCharArray()) {
            if (ch == 'B') {
                keySig = (byte)(keySig - 1);
            }
            if (ch != '#') continue;
            keySig = (byte)(keySig + 1);
        }
        return keySig;
    }

    @Override
    public String createKeyString(byte notePositionInOctave, byte scale) {
        StringBuilder buddy = new StringBuilder();
        buddy.append(Note.NOTE_NAMES_COMMON[notePositionInOctave]);
        if (scale == 1) {
            buddy.append(MAJOR_ABBR);
        } else {
            buddy.append(MINOR_ABBR);
        }
        return buddy.toString();
    }

    @Override
    public byte convertAccidentalCountToKeyRootPositionInOctave(int accidentalCount, byte scale) {
        if (scale == 1) {
            return new Note(MAJOR_KEY_SIGNATURES[7 - accidentalCount]).getPositionInOctave();
        }
        return new Note(MINOR_KEY_SIGNATURES[7 - accidentalCount]).getPositionInOctave();
    }

    @Override
    public byte convertKeyToByte(Key key) {
        String noteName = Note.getDispositionedToneStringWithoutOctave(key.getScale().getDisposition(), key.getRoot().getValue());
        if (noteName == null) {
            return 0;
        }
        for (int b = -7; b < 8; b = (int)((byte)(b + 1))) {
            if (!Note.isSameNote(noteName, key.getScale() == Scale.MAJOR ? MAJOR_KEY_SIGNATURES[7 + b] : MINOR_KEY_SIGNATURES[7 + b])) continue;
            return (byte)(b * key.getScale().getDisposition());
        }
        return 0;
    }

    static {
        MAJOR_KEY_SIGNATURES = new String[]{"Cb", "Gb", "Db", "Ab", "Eb", "Bb", "F", "C", "G", "D", "A", "E", "B", "F#", "C#"};
        MINOR_KEY_SIGNATURES = new String[]{"Ab", "Eb", "Bb", "F", "C", "G", "D", "A", "E", "B", "F#", "C#", "G#", "D#", "A#"};
    }
}

