/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.jfugue.pattern.Token;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;
import org.staccato.Subparser;

public class BeatTimeSubparser
implements Subparser {
    public static final char BEATTIME = '@';
    public static final char BEATTIME_USE_MARKER = '#';
    private static BeatTimeSubparser instance;

    public static BeatTimeSubparser getInstance() {
        if (instance == null) {
            instance = new BeatTimeSubparser();
        }
        return instance;
    }

    @Override
    public boolean matches(String music) {
        return music.charAt(0) == '@';
    }

    @Override
    public Token.TokenType getTokenType(String tokenString) {
        if (tokenString.charAt(0) == '@') {
            if (tokenString.charAt(1) == '#') {
                return Token.TokenType.TRACK_TIME_BOOKMARK_REQUESTED;
            }
            return Token.TokenType.TRACK_TIME_BOOKMARK;
        }
        return Token.TokenType.UNKNOWN_TOKEN;
    }

    @Override
    public int parse(String music, StaccatoParserContext context) {
        if (music.charAt(0) == '@') {
            int posNextSpace = StaccatoUtil.findNextOrEnd(music, ' ', 0);
            if (posNextSpace > 1) {
                String timeTrackId = music.substring(1, posNextSpace);
                if (timeTrackId.matches("([0-9]+(\\.[0-9]+)*)")) {
                    double time = Double.parseDouble(timeTrackId);
                    context.getParser().fireTrackBeatTimeRequested(time);
                } else if (timeTrackId.charAt(0) == '#') {
                    String timeBookmarkId = timeTrackId.substring(1, timeTrackId.length());
                    context.getParser().fireTrackBeatTimeBookmarkRequested(timeBookmarkId);
                }
            }
            return Math.max(1, posNextSpace);
        }
        return 0;
    }
}

