/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.theory;

import org.jfugue.provider.KeyProviderFactory;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;
import org.jfugue.theory.Scale;

public class Key {
    private Note root;
    private Scale scale;
    public static final Key DEFAULT_KEY = new Key("C4maj");

    public Key(Note root, Scale scale) {
        this.root = root;
        this.scale = scale;
    }

    public Key(Chord chord) {
        this.root = chord.getRoot();
        if (chord.isMajor()) {
            this.scale = Scale.MAJOR;
        } else if (chord.isMinor()) {
            this.scale = Scale.MINOR;
        }
    }

    public Key(String keySignature) {
        this(KeyProviderFactory.getKeyProvider().createKey(keySignature));
    }

    public Key(Key key) {
        this.root = key.root;
        this.scale = key.scale;
    }

    public String getKeySignature() {
        return this.root.toString() + this.scale.toString();
    }

    public Note getRoot() {
        return this.root;
    }

    public Scale getScale() {
        return this.scale;
    }
}

