/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.jfugue.parser.ParserListener;
import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;
import org.staccato.StaccatoUtil;

public class StaccatoParserListener
implements ParserListener,
PatternProducer {
    private Pattern pattern = new Pattern();
    private byte track;

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public void beforeParsingStarts() {
        this.pattern = new Pattern();
    }

    @Override
    public void afterParsingFinished() {
    }

    @Override
    public void onTrackChanged(byte track) {
        this.pattern.add(StaccatoUtil.createTrackElement(track));
        this.track = track;
    }

    @Override
    public void onLayerChanged(byte layer) {
        this.pattern.add(StaccatoUtil.createLayerElement(layer));
    }

    @Override
    public void onInstrumentParsed(byte instrument) {
        this.pattern.add(StaccatoUtil.createInstrumentElement(instrument));
    }

    @Override
    public void onTempoChanged(int tempoBPM) {
        this.pattern.add(StaccatoUtil.createTempoElement(tempoBPM));
    }

    @Override
    public void onKeySignatureParsed(byte key, byte scale) {
        this.pattern.add(StaccatoUtil.createKeySignatureElement(key, scale));
    }

    @Override
    public void onTimeSignatureParsed(byte numerator, byte powerOfTwo) {
        this.pattern.add(StaccatoUtil.createTimeSignatureElement(numerator, powerOfTwo));
    }

    @Override
    public void onBarLineParsed(long time) {
        this.pattern.add(StaccatoUtil.createBarLineElement(time));
    }

    @Override
    public void onTrackBeatTimeBookmarked(String timeBookmarkId) {
        this.pattern.add(StaccatoUtil.createTrackBeatTimeBookmarkElement(timeBookmarkId));
    }

    @Override
    public void onTrackBeatTimeBookmarkRequested(String timeBookmarkId) {
        this.pattern.add(StaccatoUtil.createTrackBeatTimeBookmarkRequestElement(timeBookmarkId));
    }

    @Override
    public void onTrackBeatTimeRequested(double time) {
        this.pattern.add(StaccatoUtil.createTrackBeatTimeRequestElement(time));
    }

    @Override
    public void onPitchWheelParsed(byte lsb, byte msb) {
        this.pattern.add(StaccatoUtil.createPitchWheelElement(lsb, msb));
    }

    @Override
    public void onChannelPressureParsed(byte pressure) {
        this.pattern.add(StaccatoUtil.createChannelPressureElement(pressure));
    }

    @Override
    public void onPolyphonicPressureParsed(byte key, byte pressure) {
        this.pattern.add(StaccatoUtil.createPolyphonicPressureElement(key, pressure));
    }

    @Override
    public void onSystemExclusiveParsed(byte ... bytes) {
        this.pattern.add(StaccatoUtil.createSystemExclusiveElement(bytes));
    }

    @Override
    public void onControllerEventParsed(byte controller, byte value) {
        this.pattern.add(StaccatoUtil.createControllerEventElement(controller, value));
    }

    @Override
    public void onLyricParsed(String lyric) {
        this.pattern.add(StaccatoUtil.createLyricElement(lyric));
    }

    @Override
    public void onMarkerParsed(String marker) {
        this.pattern.add(StaccatoUtil.createMarkerElement(marker));
    }

    @Override
    public void onFunctionParsed(String id, Object message) {
        this.pattern.add(StaccatoUtil.createFunctionElement(id, message));
    }

    @Override
    public void onNotePressed(Note note) {
    }

    @Override
    public void onNoteReleased(Note note) {
    }

    @Override
    public void onNoteParsed(Note note) {
        this.pattern.add(StaccatoUtil.createNoteElement(note, this.track));
    }

    @Override
    public void onChordParsed(Chord chord) {
        this.pattern.add(StaccatoUtil.createChordElement(chord));
    }
}

