/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.staccato.Preprocessor;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;

public class CollectedNotesPreprocessor
implements Preprocessor {
    private static CollectedNotesPreprocessor instance;
    private static Pattern parenPattern;
    private static final char[] SPACE;
    private static final char[] SPACE_PLUS;

    public static CollectedNotesPreprocessor getInstance() {
        if (instance == null) {
            instance = new CollectedNotesPreprocessor();
        }
        return instance;
    }

    @Override
    public String preprocess(String s, StaccatoParserContext context) {
        StringBuilder buddy = new StringBuilder();
        int posStart = 0;
        Matcher m = parenPattern.matcher(s);
        while (m.find()) {
            int posStartOfGroup = m.start();
            String sub = s.substring(posStart, posStartOfGroup);
            buddy.append(sub);
            posStart = StaccatoUtil.findNextOrEnd(s, SPACE, m.end());
            int posCloseParen = s.indexOf(41, posStartOfGroup);
            String replicand = s.substring(posCloseParen + 1, StaccatoUtil.findNextOrEnd(s, SPACE_PLUS, posCloseParen + 1));
            String parenContents = s.substring(posStartOfGroup + 1, posCloseParen);
            int subindex = 0;
            int posSomething = -1;
            while (subindex < parenContents.length()) {
                posSomething = StaccatoUtil.findNextOrEnd(parenContents, SPACE_PLUS, subindex);
                buddy.append(parenContents.substring(subindex, posSomething));
                buddy.append(replicand);
                if (posSomething != parenContents.length()) {
                    buddy.append(parenContents.substring(posSomething, posSomething + 1));
                }
                subindex = posSomething + 1;
            }
        }
        buddy.append(s.substring(posStart, s.length()));
        return buddy.toString();
    }

    static {
        parenPattern = Pattern.compile("\\([^\\)]*\\)\\S");
        SPACE = new char[]{' '};
        SPACE_PLUS = new char[]{' ', '+'};
    }
}

