/*
 * Decompiled with CFR 0.152.
 */
package org.staccato.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfugue.midi.TrackTimeManager;
import org.jfugue.parser.ParserListener;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;
import org.staccato.StaccatoParser;
import org.staccato.StaccatoUtil;
import org.staccato.tools.ElementWithTrack;

public class StaccatoElementSorter
extends TrackTimeManager
implements ParserListener {
    private Map<Double, List<ElementWithTrack>> timeMap = new HashMap<Double, List<ElementWithTrack>>();
    private double initialNoteBeatTime;

    public Map<Double, List<ElementWithTrack>> getSortedElements() {
        return this.timeMap;
    }

    public static Map<Double, List<ElementWithTrack>> sortElements(PatternProducer patternProducer) {
        return StaccatoElementSorter.sortElements(patternProducer.getPattern().toString());
    }

    public static Map<Double, List<ElementWithTrack>> sortElements(String string) {
        StaccatoParser parser = new StaccatoParser();
        StaccatoElementSorter sorter = new StaccatoElementSorter();
        parser.addParserListener(sorter);
        parser.parse(string);
        return sorter.getSortedElements();
    }

    @Override
    public void beforeParsingStarts() {
    }

    @Override
    public void afterParsingFinished() {
    }

    @Override
    public void onTrackChanged(byte track) {
        super.setCurrentTrack(track);
    }

    @Override
    public void onLayerChanged(byte layer) {
        super.setCurrentLayerNumber(layer);
    }

    @Override
    public void onInstrumentParsed(byte instrument) {
        this.addToTimeMap(StaccatoUtil.createInstrumentElement(instrument));
    }

    @Override
    public void onTempoChanged(int tempoBPM) {
        this.addToTimeMap(StaccatoUtil.createTempoElement(tempoBPM));
    }

    @Override
    public void onKeySignatureParsed(byte key, byte scale) {
        this.addToTimeMap(StaccatoUtil.createKeySignatureElement(key, scale));
    }

    @Override
    public void onTimeSignatureParsed(byte numerator, byte powerOfTwo) {
        this.addToTimeMap(StaccatoUtil.createTimeSignatureElement(numerator, powerOfTwo));
    }

    @Override
    public void onBarLineParsed(long id) {
        this.addToTimeMap(StaccatoUtil.createBarLineElement(id));
    }

    @Override
    public void onTrackBeatTimeBookmarked(String timeBookmarkId) {
        super.addTrackTickTimeBookmark(timeBookmarkId);
    }

    @Override
    public void onTrackBeatTimeBookmarkRequested(String timeBookmarkId) {
        double time = super.getTrackBeatTimeBookmark(timeBookmarkId);
        super.setTrackBeatTime(time);
    }

    @Override
    public void onTrackBeatTimeRequested(double time) {
        super.setTrackBeatTime(time);
    }

    @Override
    public void onPitchWheelParsed(byte lsb, byte msb) {
        this.addToTimeMap(StaccatoUtil.createPitchWheelElement(lsb, msb));
    }

    @Override
    public void onChannelPressureParsed(byte pressure) {
        this.addToTimeMap(StaccatoUtil.createChannelPressureElement(pressure));
    }

    @Override
    public void onPolyphonicPressureParsed(byte key, byte pressure) {
        this.addToTimeMap(StaccatoUtil.createPolyphonicPressureElement(key, pressure));
    }

    @Override
    public void onSystemExclusiveParsed(byte ... bytes) {
        this.addToTimeMap(StaccatoUtil.createSystemExclusiveElement(bytes));
    }

    @Override
    public void onControllerEventParsed(byte controller, byte value) {
        this.addToTimeMap(StaccatoUtil.createControllerEventElement(controller, value));
    }

    @Override
    public void onLyricParsed(String lyric) {
        this.addToTimeMap(StaccatoUtil.createLyricElement(lyric));
    }

    @Override
    public void onMarkerParsed(String marker) {
        this.addToTimeMap(StaccatoUtil.createMarkerElement(marker));
    }

    @Override
    public void onFunctionParsed(String id, Object message) {
        this.addToTimeMap(StaccatoUtil.createFunctionElement(id, message));
    }

    @Override
    public void onNotePressed(Note note) {
    }

    @Override
    public void onNoteReleased(Note note) {
    }

    @Override
    public void onNoteParsed(Note note) {
        this.addNote(note);
    }

    @Override
    public void onChordParsed(Chord chord) {
        for (Note note : chord.getNotes()) {
            this.addNote(note);
        }
    }

    private void addNote(Note note) {
        if (note.getDuration() == 0.0) {
            note.useDefaultDuration();
        }
        if (note.isFirstNote()) {
            this.initialNoteBeatTime = this.getTrackBeatTime();
        }
        if (note.isHarmonicNote()) {
            this.setTrackBeatTime(this.initialNoteBeatTime);
        }
        if (note.isRest()) {
            this.advanceTrackBeatTime(note.getDuration());
            return;
        }
        this.addToTimeMap(StaccatoUtil.createNoteElement(note));
        this.advanceTrackBeatTime(note.getDuration());
    }

    private void addToTimeMap(String string) {
        ElementWithTrack elementWithTrack = new ElementWithTrack(this.getCurrentTrackNumber(), this.getCurrentLayerNumber(), string);
        List<ElementWithTrack> elementList = this.timeMap.get(this.getTrackBeatTime());
        if (elementList == null) {
            elementList = new ArrayList<ElementWithTrack>();
            this.timeMap.put(this.getTrackBeatTime(), elementList);
        }
        elementList.add(elementWithTrack);
    }
}

