/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.staccato.Preprocessor;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;

public class ParenSpacesPreprocessor
implements Preprocessor {
    private static ParenSpacesPreprocessor instance;

    public static ParenSpacesPreprocessor getInstance() {
        if (instance == null) {
            instance = new ParenSpacesPreprocessor();
        }
        return instance;
    }

    @Override
    public String preprocess(String s, StaccatoParserContext context) {
        StringBuilder buddy = new StringBuilder();
        int pos = 0;
        while (pos < s.length()) {
            int keepSpacesUntil = StaccatoUtil.findNextOrEnd(s, '(', pos);
            int endParen = StaccatoUtil.findNextOrEnd(s, ')', keepSpacesUntil);
            buddy.append(s.substring(pos, keepSpacesUntil));
            for (int i = keepSpacesUntil; i < endParen; ++i) {
                if (s.charAt(i) == ' ') {
                    buddy.append('_');
                    continue;
                }
                buddy.append(s.charAt(i));
            }
            pos = endParen;
        }
        return buddy.toString();
    }

    public static String unprocess(String s) {
        StringBuilder buddy = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '_') {
                buddy.append(' ');
                continue;
            }
            buddy.append(s.charAt(i));
        }
        return buddy.toString();
    }
}

