/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.theory;

import org.jfugue.theory.Intervals;

public class Scale {
    private Intervals intervals;
    private String name;
    private byte majorMinorIndicator;
    public static final Scale MAJOR = new Scale(new Intervals("1 2 3 4 5 6 7")).setMajorOrMinorIndicator((byte)1);
    public static final Scale MINOR = new Scale(new Intervals("1 2 b3 4 5 b6 b7")).setMajorOrMinorIndicator((byte)-1);
    public static final Scale CIRCLE_OF_FIFTHS = new Scale(new Intervals("1 2 3b 4 5 6 7b"));
    public static final byte MAJOR_INDICATOR = 1;
    public static final byte MINOR_INDICATOR = -1;

    public Scale(String intervalString) {
        this(new Intervals(intervalString));
    }

    public Scale(String intervalString, String name) {
        this(new Intervals(intervalString), name);
    }

    public Scale(Intervals pattern) {
        this.intervals = pattern;
    }

    public Scale(Intervals pattern, String name) {
        this.intervals = pattern;
        this.name = name;
    }

    public Scale setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Intervals getIntervals() {
        return this.intervals;
    }

    public Scale setMajorOrMinorIndicator(byte indicator) {
        this.majorMinorIndicator = indicator;
        return this;
    }

    public byte getMajorOrMinorIndicator() {
        return this.majorMinorIndicator;
    }

    public int getDisposition() {
        return this.majorMinorIndicator == 1 ? 1 : -1;
    }

    public String toString() {
        if (this.majorMinorIndicator == 1) {
            return "maj";
        }
        if (this.majorMinorIndicator == -1) {
            return "min";
        }
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Scale)) {
            return false;
        }
        return ((Scale)o).intervals.equals(this.intervals);
    }

    public int hashCode() {
        return this.intervals.hashCode();
    }
}

