/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.realtime;

import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;
import org.jfugue.midi.MidiDictionary;
import org.jfugue.midi.MidiTools;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.player.SynthesizerManager;
import org.jfugue.realtime.RealtimeInterpolator;
import org.jfugue.realtime.RealtimeMidiParserListener;
import org.jfugue.realtime.ScheduledEvent;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;
import org.staccato.StaccatoParser;

public class RealtimePlayer {
    private Synthesizer synth = SynthesizerManager.getInstance().getSynthesizer();
    private MidiChannel[] channels;
    private int currentChannel;
    private StaccatoParser staccatoParser;
    private RealtimeMidiParserListener rtMidiParserListener;

    public RealtimePlayer() throws MidiUnavailableException {
        this.synth.open();
        this.channels = this.synth.getChannels();
        this.staccatoParser = new StaccatoParser();
        this.rtMidiParserListener = new RealtimeMidiParserListener(this);
        this.staccatoParser.addParserListener(this.rtMidiParserListener);
    }

    public void play(PatternProducer pattern) {
        this.staccatoParser.parse(pattern);
    }

    public void play(String pattern) {
        this.staccatoParser.parse(pattern);
    }

    protected MidiChannel getCurrentChannel() {
        return this.channels[this.currentChannel];
    }

    public long getCurrentTime() {
        return this.rtMidiParserListener.getCurrentTime();
    }

    public void schedule(long timeInMillis, ScheduledEvent event) {
        this.rtMidiParserListener.onEventScheduled(timeInMillis, event);
    }

    public void unschedule(long timeInMillis, ScheduledEvent event) {
        this.rtMidiParserListener.onEventUnscheduled(timeInMillis, event);
    }

    public void startNote(Note note) {
        this.getCurrentChannel().noteOn(note.getValue(), note.getOnVelocity());
    }

    public void stopNote(Note note) {
        this.getCurrentChannel().noteOff(note.getValue(), note.getOffVelocity());
    }

    public void startChord(Chord chord) {
        for (Note note : chord.getNotes()) {
            this.startNote(note);
        }
    }

    public void stopChord(Chord chord) {
        for (Note note : chord.getNotes()) {
            this.stopNote(note);
        }
    }

    public void startInterpolator(RealtimeInterpolator interpolator, long durationInMillis) {
        this.rtMidiParserListener.onInterpolatorStarted(interpolator, durationInMillis);
    }

    public void stopInterpolator(RealtimeInterpolator interpolator) {
        this.rtMidiParserListener.onInterpolatorStopping(interpolator);
    }

    public void changeInstrument(int newInstrument) {
        this.getCurrentChannel().programChange(newInstrument);
    }

    public void changeInstrument(String newInstrument) {
        this.getCurrentChannel().programChange(MidiDictionary.INSTRUMENT_STRING_TO_BYTE.get(newInstrument.toUpperCase()).byteValue());
    }

    public void changeTrack(int newTrack) {
        this.currentChannel = newTrack;
    }

    public void setPitchBend(int pitch) {
        this.setPitchBend(MidiTools.getLSB(pitch), MidiTools.getMSB(pitch));
    }

    public void setPitchBend(byte lsb, byte msb) {
        this.getCurrentChannel().setPitchBend(lsb + (msb << 7));
    }

    public void changeChannelPressure(byte pressure) {
        this.getCurrentChannel().setChannelPressure(pressure);
    }

    public void changePolyphonicPressure(byte key, byte pressure) {
        this.getCurrentChannel().setPolyPressure(key, pressure);
    }

    public void changeController(byte controller, byte value) {
        this.getCurrentChannel().controlChange(controller, value);
    }

    public void close() {
        for (MidiChannel channel : this.channels) {
            channel.allNotesOff();
        }
        this.rtMidiParserListener.finish();
    }
}

