/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.midi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import org.jfugue.midi.AuxilliaryMidiParser;
import org.jfugue.parser.Parser;
import org.jfugue.provider.KeyProviderFactory;
import org.jfugue.theory.Note;

public class MidiParser
extends Parser {
    private List<Map<Byte, TempNote>> noteCache;
    private float divisionType = 0.0f;
    private int resolutionTicksPerBeat = 128;
    private int tempoBPM = 120;
    private int currentChannel = -1;
    private double[] currentTimeInBeats;
    private double[] expectedTimeInBeats;
    private List<AuxilliaryMidiParser> auxilliaryParsers = new ArrayList<AuxilliaryMidiParser>();

    public void parse(Sequence sequence) {
        this.startParser();
        this.divisionType = sequence.getDivisionType();
        this.resolutionTicksPerBeat = sequence.getResolution();
        for (Track track : sequence.getTracks()) {
            for (int i = 0; i < track.size(); ++i) {
                MidiEvent event = track.get(i);
                this.parseEvent(event);
            }
        }
        this.stopParser();
    }

    public void startParser() {
        this.fireBeforeParsingStarts();
        this.initNoteCache();
        this.divisionType = 0.0f;
        this.resolutionTicksPerBeat = 128;
    }

    public void stopParser() {
        this.fireAfterParsingFinished();
    }

    private void initNoteCache() {
        this.noteCache = new ArrayList<Map<Byte, TempNote>>();
        this.currentTimeInBeats = new double[16];
        this.expectedTimeInBeats = new double[16];
        for (int i = 0; i < 16; ++i) {
            this.noteCache.add(new HashMap());
            this.currentTimeInBeats[i] = 0.0;
            this.expectedTimeInBeats[i] = 0.0;
        }
    }

    public void parseEvent(MidiEvent event) {
        MidiMessage message = event.getMessage();
        if (message instanceof ShortMessage) {
            this.parseShortMessage((ShortMessage)message, event);
        } else if (message instanceof MetaMessage) {
            this.parseMetaMessage((MetaMessage)message, event);
        } else if (message instanceof SysexMessage) {
            this.parseSysexMessage((SysexMessage)message, event);
        } else {
            this.fireUnhandledMidiEvent(event);
        }
    }

    private void parseShortMessage(ShortMessage message, MidiEvent event) {
        if (!this.isNoteOnEvent(message.getCommand(), message.getChannel(), event)) {
            this.checkChannel(message.getChannel());
        }
        switch (message.getCommand()) {
            case 128: {
                this.noteOff(message.getChannel(), event);
                this.fireHandledMidiEvent(event);
                break;
            }
            case 144: {
                this.noteOn(message.getChannel(), event);
                this.fireHandledMidiEvent(event);
                break;
            }
            case 160: {
                this.polyphonicAftertouch(message.getChannel(), event);
                this.fireHandledMidiEvent(event);
                break;
            }
            case 176: {
                this.controlChange(message.getChannel(), event);
                this.fireHandledMidiEvent(event);
                break;
            }
            case 192: {
                this.programChange(message.getChannel(), event);
                this.fireHandledMidiEvent(event);
                break;
            }
            case 208: {
                this.channelAftertouch(message.getChannel(), event);
                this.fireHandledMidiEvent(event);
                break;
            }
            case 224: {
                this.pitchWheel(message.getChannel(), event);
                this.fireHandledMidiEvent(event);
                break;
            }
            default: {
                this.fireUnhandledMidiEvent(event);
            }
        }
    }

    private void parseMetaMessage(MetaMessage message, MidiEvent event) {
        switch (message.getType()) {
            case 0: {
                this.fireUnhandledMidiEvent(event);
                break;
            }
            case 1: {
                this.fireUnhandledMidiEvent(event);
                break;
            }
            case 2: {
                this.fireUnhandledMidiEvent(event);
                break;
            }
            case 3: {
                this.fireUnhandledMidiEvent(event);
                break;
            }
            case 4: {
                this.fireUnhandledMidiEvent(event);
                break;
            }
            case 5: {
                this.lyricParsed(message);
                this.fireHandledMidiEvent(event);
                break;
            }
            case 6: {
                this.markerParsed(message);
                this.fireHandledMidiEvent(event);
                break;
            }
            case 7: {
                this.fireUnhandledMidiEvent(event);
                break;
            }
            case 32: {
                this.fireUnhandledMidiEvent(event);
                break;
            }
            case 47: {
                this.fireUnhandledMidiEvent(event);
                break;
            }
            case 81: {
                this.tempoChanged(message);
                this.fireHandledMidiEvent(event);
                break;
            }
            case 84: {
                this.fireUnhandledMidiEvent(event);
                break;
            }
            case 88: {
                this.timeSigParsed(message);
                this.fireHandledMidiEvent(event);
                break;
            }
            case 89: {
                this.keySigParsed(message);
                this.fireHandledMidiEvent(event);
                break;
            }
            case 127: {
                this.fireUnhandledMidiEvent(event);
                break;
            }
            default: {
                this.fireUnhandledMidiEvent(event);
            }
        }
    }

    private void parseSysexMessage(SysexMessage message, MidiEvent event) {
        this.sysexParsed(message);
        this.fireHandledMidiEvent(event);
    }

    private boolean isNoteOnEvent(int command, int channel, MidiEvent event) {
        return command == 144 && (this.noteCache.get(channel).get(event.getMessage().getMessage()[1]) == null || event.getMessage().getMessage()[2] != 0);
    }

    private boolean isNoteOffEvent(int command, int channel, MidiEvent event) {
        return command == 128 || command == 144 && this.noteCache.get(channel).get(event.getMessage().getMessage()[1]) != null && event.getMessage().getMessage()[2] == 0;
    }

    private void noteOff(int channel, MidiEvent event) {
        byte note = event.getMessage().getMessage()[1];
        TempNote tempNote = this.noteCache.get(channel).get(note);
        if (tempNote == null) {
            return;
        }
        this.noteCache.get(channel).remove(note);
        this.checkTime(tempNote.startTick);
        long durationInTicks = event.getTick() - tempNote.startTick;
        double durationInBeats = this.getDurationInBeats(durationInTicks);
        byte noteOffVelocity = event.getMessage().getMessage()[2];
        this.expectedTimeInBeats[this.currentChannel] = this.currentTimeInBeats[this.currentChannel] + durationInBeats;
        Note noteObject = new Note(note);
        noteObject.setDuration(this.getDurationInBeats(durationInTicks));
        noteObject.setOnVelocity(tempNote.noteOnVelocity);
        noteObject.setOffVelocity(noteOffVelocity);
        this.fireNoteReleased(new Note(note).setOffVelocity(noteOffVelocity));
        this.fireNoteParsed(noteObject);
    }

    private void noteOn(int channel, MidiEvent event) {
        if (this.isNoteOffEvent(144, channel, event)) {
            this.noteOff(channel, event);
            return;
        }
        byte note = event.getMessage().getMessage()[1];
        byte noteOnVelocity = event.getMessage().getMessage()[2];
        if (this.noteCache.get(channel).get(note) == null) {
            this.noteCache.get(channel).put(note, new TempNote(event.getTick(), noteOnVelocity));
        }
        this.fireNotePressed(new Note(note).setOnVelocity(noteOnVelocity));
    }

    private void polyphonicAftertouch(int channel, MidiEvent event) {
        this.firePolyphonicPressureParsed(event.getMessage().getMessage()[1], event.getMessage().getMessage()[2]);
    }

    private void controlChange(int channel, MidiEvent event) {
        this.fireControllerEventParsed(event.getMessage().getMessage()[1], event.getMessage().getMessage()[2]);
    }

    private void programChange(int channel, MidiEvent event) {
        this.fireInstrumentParsed(event.getMessage().getMessage()[1]);
    }

    private void channelAftertouch(int channel, MidiEvent event) {
        this.fireChannelPressureParsed(event.getMessage().getMessage()[1]);
    }

    private void pitchWheel(int channel, MidiEvent event) {
        this.firePitchWheelParsed(event.getMessage().getMessage()[1], event.getMessage().getMessage()[2]);
    }

    private void tempoChanged(MetaMessage meta) {
        int newTempoMSPQ = meta.getData()[2] & 0xFF | (meta.getData()[1] & 0xFF) << 8 | (meta.getData()[0] & 0xFF) << 16;
        this.tempoBPM = newTempoMSPQ = 60000000 / newTempoMSPQ;
        this.fireTempoChanged(this.tempoBPM);
    }

    private void lyricParsed(MetaMessage meta) {
        this.fireLyricParsed(new String(meta.getData()));
    }

    private void markerParsed(MetaMessage meta) {
        this.fireMarkerParsed(new String(meta.getData()));
    }

    private void keySigParsed(MetaMessage meta) {
        byte scale = meta.getData()[1] == 0 ? (byte)1 : -1;
        this.fireKeySignatureParsed(KeyProviderFactory.getKeyProvider().convertAccidentalCountToKeyRootPositionInOctave(meta.getData()[0], scale), scale);
    }

    private void timeSigParsed(MetaMessage meta) {
        this.fireTimeSignatureParsed(meta.getData()[0], meta.getData()[1]);
    }

    private void sysexParsed(SysexMessage sysex) {
        this.fireSystemExclusiveParsed(sysex.getData());
    }

    private void checkTime(long tick) {
        double newTimeInBeats = this.getDurationInBeats(tick);
        if (this.expectedTimeInBeats[this.currentChannel] != newTimeInBeats) {
            if (newTimeInBeats > this.expectedTimeInBeats[this.currentChannel]) {
                this.fireNoteParsed(Note.createRest(newTimeInBeats - this.expectedTimeInBeats[this.currentChannel]));
            } else {
                this.fireTrackBeatTimeRequested(newTimeInBeats);
            }
        }
        this.currentTimeInBeats[this.currentChannel] = newTimeInBeats;
    }

    private void checkChannel(int channel) {
        if (this.currentChannel != channel) {
            this.fireTrackChanged((byte)channel);
            this.currentChannel = channel;
        }
    }

    private double getDurationInBeats(long durationInTicks) {
        return (double)durationInTicks / (double)this.resolutionTicksPerBeat / 4.0;
    }

    private long ticksToMs(long ticks) {
        return (long)((double)(ticks / (long)this.resolutionTicksPerBeat) * (1.0 / (double)this.tempoBPM) * 60000.0);
    }

    private long msToTicks(long ms) {
        return (long)((double)ms / 60000.0 * (double)this.tempoBPM * (double)this.resolutionTicksPerBeat);
    }

    public void addAuxilliaryMidiParser(AuxilliaryMidiParser auxilliaryParser) {
        this.auxilliaryParsers.add(auxilliaryParser);
    }

    public void removeAuxilliaryMidiParser(AuxilliaryMidiParser auxilliaryParser) {
        this.auxilliaryParsers.remove(auxilliaryParser);
    }

    protected void fireHandledMidiEvent(MidiEvent event) {
        for (AuxilliaryMidiParser auxilliaryParser : this.auxilliaryParsers) {
            auxilliaryParser.parseHandledMidiEvent(event, this);
        }
    }

    protected void fireUnhandledMidiEvent(MidiEvent event) {
        for (AuxilliaryMidiParser auxilliaryParser : this.auxilliaryParsers) {
            auxilliaryParser.parseUnhandledMidiEvent(event, this);
        }
    }

    class TempNote {
        long startTick;
        byte noteOnVelocity;

        public TempNote(long startTick, byte noteOnVelocity) {
            this.startTick = startTick;
            this.noteOnVelocity = noteOnVelocity;
        }
    }
}

