/*
 * Decompiled with CFR 0.152.
 */
package org.staccato.functions;

import org.staccato.DefaultNoteSettingsManager;
import org.staccato.PreprocessorFunction;
import org.staccato.StaccatoParserContext;

public class DefaultPreprocessorFunction
implements PreprocessorFunction {
    private static DefaultPreprocessorFunction instance;
    private static String OCTAVE;
    private static String BASE_OCTAVE;
    private static String DURATION;
    private static String ATTACK;
    private static String DECAY;
    private String[] NAMES = new String[]{"DEFAULT", "DEFAULTS"};

    private DefaultPreprocessorFunction() {
    }

    public static DefaultPreprocessorFunction getInstance() {
        if (instance == null) {
            instance = new DefaultPreprocessorFunction();
        }
        return instance;
    }

    @Override
    public String apply(String parameters, StaccatoParserContext context) {
        String[] defaultSettings;
        for (String defaultSetting : defaultSettings = parameters.split(",")) {
            String[] defaultValues = defaultSetting.split("=");
            if (defaultValues.length != 2) {
                throw new RuntimeException("DefaultProcessor found this setting, which is not in the form KEY=VALUE: " + defaultSetting);
            }
            String key = defaultValues[0];
            String value = defaultValues[1];
            if (key.equalsIgnoreCase(OCTAVE)) {
                DefaultNoteSettingsManager.getInstance().setDefaultOctave(Byte.parseByte(value));
                continue;
            }
            if (key.equalsIgnoreCase(BASE_OCTAVE)) {
                DefaultNoteSettingsManager.getInstance().setDefaultBassOctave(Byte.parseByte(value));
                continue;
            }
            if (key.equalsIgnoreCase(DURATION)) {
                double dur = 0.0;
                try {
                    dur = Double.parseDouble(value);
                    DefaultNoteSettingsManager.getInstance().setDefaultDuration(dur);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Currently, default duration must be specified as a decimal. For example, please use 0.5 for 'h', 0.25 for 'q', and so on. You had entered: " + value);
                }
            }
            if (key.equalsIgnoreCase(ATTACK)) {
                DefaultNoteSettingsManager.getInstance().setDefaultOnVelocity(Byte.parseByte(value));
                continue;
            }
            if (key.equalsIgnoreCase(DECAY)) {
                DefaultNoteSettingsManager.getInstance().setDefaultOffVelocity(Byte.parseByte(value));
                continue;
            }
            throw new RuntimeException("DefaultProcessor found this setting where the key is not recognized: " + defaultSetting + " (key should be one of the following: " + OCTAVE + ", " + BASE_OCTAVE + ", " + DURATION + ", " + ATTACK + ", or " + DECAY);
        }
        return "";
    }

    @Override
    public String[] getNames() {
        return this.NAMES;
    }

    static {
        OCTAVE = "OCTAVE";
        BASE_OCTAVE = "BASS_OCTAVE";
        DURATION = "DURATION";
        ATTACK = "ATTACK";
        DECAY = "DECAY";
    }
}

