package br.com.caelum.xstream;

import static org.junit.Assert.assertEquals;

import java.util.ArrayList;
import java.util.List;

import org.junit.Test;

import com.thoughtworks.xstream.XStream;

public class CompraTest {

	@Test
	public void deveSerializarCadaUmDosProdutosDeUmaCompra() {
		String resultadoEsperado = "<compra>\n" + "  <id>15</id>\n"
				+ "  <produtos>\n" + "    <produto codigo=\"1587\">\n"
				+ "      <nome>geladeira</nome>\n"
				+ "      <preco>1000.0</preco>\n"
				+ "      <descrição>geladeira duas portas</descrição>\n"
				+ "    </produto>\n" + "    <produto codigo=\"1588\">\n"
				+ "      <nome>ferro de passar</nome>\n"
				+ "      <preco>100.0</preco>\n"
				+ "      <descrição>ferro com vaporizador</descrição>\n"
				+ "    </produto>\n" + "  </produtos>\n" + "</compra>";

		Compra compra = compraComGeladeiraEFerro();

		XStream xstream = xstreamParaCompraEProduto();

		String xmlGerado = xstream.toXML(compra);

		assertEquals(resultadoEsperado, xmlGerado);
	}

	private Compra compraComGeladeiraEFerro() {
		Produto geladeira = geladeira();
		Produto ferro = ferro();
		List<Produto> produtos = new ArrayList<Produto>();
		produtos.add(geladeira);
		produtos.add(ferro);

		Compra compra = new Compra(15, produtos);
		return compra;
	}

	private Produto ferro() {
		return new Produto("ferro de passar", 100,
				"ferro com vaporizador", 1588);
	}

	private Produto geladeira() {
		return new Produto("geladeira", 1000,
				"geladeira duas portas", 1587);
	}

	@Test
	public void deveGerarUmaCompraComOsProdutosAdequados() {
		String xmlDeOrigem = "<compra>\n" + "  <id>15</id>\n"
				+ "  <produtos>\n" + "    <produto codigo=\"1587\">\n"
				+ "      <nome>geladeira</nome>\n"
				+ "      <preco>1000.0</preco>\n"
				+ "      <descrição>geladeira duas portas</descrição>\n"
				+ "    </produto>\n" + "    <produto codigo=\"1588\">\n"
				+ "      <nome>ferro de passar</nome>\n"
				+ "      <preco>100.0</preco>\n"
				+ "      <descrição>ferro com vaporizador</descrição>\n"
				+ "    </produto>\n" + "  </produtos>\n" + "</compra>";

		XStream xstream = xstreamParaCompraEProduto();

		Compra compraResultado = (Compra) xstream.fromXML(xmlDeOrigem);

		Compra compraEsperada = compraComGeladeiraEFerro();
		assertEquals(compraEsperada, compraResultado);

	}

	private XStream xstreamParaCompraEProduto() {
		XStream xstream = new XStream();
		xstream.alias("compra", Compra.class);
		xstream.alias("produto", Produto.class);
		xstream.aliasField("descrição", Produto.class, "descricao");
		xstream.useAttributeFor(Produto.class, "codigo");
		return xstream;
	}

	private Compra compraDuasGeladeirasIguais() {
		Produto geladeira = geladeira();

		List<Produto> produtos = new ArrayList<Produto>();
		produtos.add(geladeira);
		produtos.add(geladeira);

		Compra compra = new Compra(15, produtos);
		return compra;
	}
	
	@Test
	public void deveSerializarDuasGeladeirasIguais() {
		String resultadoEsperado = "<compra>\n" 
				+ "  <id>15</id>\n"
				+ "  <produtos>\n" 
				+ "    <produto codigo=\"1587\">\n"
				+ "      <nome>geladeira</nome>\n"
				+ "      <preco>1000.0</preco>\n"
				+ "      <descrição>geladeira duas portas</descrição>\n"
				+ "    </produto>\n"
				+ "    <produto codigo=\"1587\">\n"
				+ "      <nome>geladeira</nome>\n"
				+ "      <preco>1000.0</preco>\n"
				+ "      <descrição>geladeira duas portas</descrição>\n"
				+ "    </produto>\n"
				+ "  </produtos>\n" 
				+ "</compra>";

		Compra compra = compraDuasGeladeirasIguais();

		XStream xstream = xstreamParaCompraEProduto();
		xstream.setMode(XStream.NO_REFERENCES);

		String xmlGerado = xstream.toXML(compra);

		assertEquals(resultadoEsperado, xmlGerado);
	}
	
}
