/*
 * Decompiled with CFR 0.152.
 */
package controlador.apoios;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;

public class ProcessadorExprSimples {
    public final String mathExpr = "((\\(*[+-]*[0-9]+\\.?[0-9]*\\)*[+-/%\\*/^])*|(\\(*\\$\\w+\\)*[+-/%\\*/^])*)*";
    private boolean Erro = false;
    public final char[] operadores = new char[]{'+', '-', '/', '*', '%', '^'};

    public int processaExprInt(String expr) throws Exception {
        this.Erro = false;
        String res = this.processaMathExp(expr.replace(" ", ""));
        if (this.isErro()) {
            throw new Exception("Format");
        }
        return (int)Double.parseDouble(res);
    }

    public boolean IsMathExpr(String v2) {
        String tmp = v2.replaceAll(" ", "") + "+";
        return tmp.matches("((\\(*[+-]*[0-9]+\\.?[0-9]*\\)*[+-/%\\*/^])*|(\\(*\\$\\w+\\)*[+-/%\\*/^])*)*");
    }

    public boolean isErro() {
        return this.Erro;
    }

    public void setErro(boolean Erro) {
        this.Erro = Erro;
    }

    public boolean isOperador(char sep) {
        for (char a : this.operadores) {
            if (a != sep) continue;
            return true;
        }
        return false;
    }

    public String processaMathExp(String expr) {
        if (expr.isEmpty()) {
            return "";
        }
        int inipar = expr.indexOf("(");
        int fimpar = -1;
        int abr = 0;
        for (int i = inipar + 1; i < expr.length(); ++i) {
            char a = expr.toCharArray()[i];
            if (a == '(') {
                ++abr;
            }
            if (a != ')') continue;
            if (abr > 0) {
                --abr;
                continue;
            }
            fimpar = i;
            break;
        }
        if (inipar > -1 && fimpar == -1 || inipar == -1 && fimpar > -1 || inipar > fimpar) {
            this.setErro(true);
            return "";
        }
        if (inipar > -1 && fimpar > -1) {
            char t;
            if (inipar > 0 && !this.isOperador(t = expr.toCharArray()[inipar - 1])) {
                this.setErro(true);
                return "";
            }
            String tmp = expr.substring(inipar, fimpar + 1);
            String tmp2 = expr.substring(inipar + 1, fimpar);
            expr = expr.replace(tmp, this.processaMathExp(tmp2));
            if (this.isErro()) {
                return "";
            }
            return this.processaMathExp(expr);
        }
        StringBuilder str = new StringBuilder();
        char[] arr = expr.toCharArray();
        int oper = 0;
        for (int i = 0; i < expr.length(); ++i) {
            if (arr[i] == '+' || arr[i] == '-') {
                if (oper != 0) {
                    if (arr[i] != '-') continue;
                    if (oper == 45) {
                        oper = 43;
                        continue;
                    }
                    oper = 45;
                    continue;
                }
                oper = arr[i];
                continue;
            }
            if (oper != 0) {
                str.append((char)oper);
                oper = 0;
            }
            str.append(arr[i]);
        }
        expr = str.toString();
        str = new StringBuilder();
        String palavra = "";
        boolean negativo = false;
        ArrayList<BigDecimal> num = new ArrayList<BigDecimal>();
        ArrayList<String> opers = new ArrayList<String>();
        expr = expr + "+0";
        for (char tx : expr.toCharArray()) {
            if (this.isOperador(tx)) {
                palavra = str.toString();
                if (!palavra.isEmpty()) {
                    try {
                        if (this.isVariavel(palavra)) {
                            palavra = this.getVarValue(palavra);
                        } else if (palavra.matches("\\$\\w+")) {
                            this.setErro(true);
                            return "";
                        }
                        BigDecimal p = new BigDecimal(palavra);
                        if (negativo) {
                            p = p.negate();
                            negativo = false;
                        }
                        num.add(p);
                        palavra = "";
                        opers.add(String.valueOf(tx));
                        str = new StringBuilder();
                        continue;
                    }
                    catch (NumberFormatException er) {
                        this.setErro(true);
                        return "";
                    }
                }
                if (tx == '-') {
                    negativo = true;
                    continue;
                }
                if (tx == '+') continue;
                this.setErro(true);
                return "";
            }
            str.append(tx);
        }
        if (num.isEmpty()) {
            this.setErro(true);
            return "";
        }
        BigDecimal res = (BigDecimal)num.get(0);
        for (int i = 1; i < num.size(); ++i) {
            BigDecimal v1 = (BigDecimal)num.get(i);
            String op = (String)opers.get(i - 1);
            try {
                switch (op) {
                    case "+": {
                        res = res.add(v1);
                        break;
                    }
                    case "-": {
                        res = res.subtract(v1);
                        break;
                    }
                    case "*": {
                        res = res.multiply(v1);
                        break;
                    }
                    case "/": {
                        res = res.divide(v1, 5, RoundingMode.FLOOR);
                        break;
                    }
                    case "%": {
                        res = res.remainder(v1);
                        break;
                    }
                    case "^": {
                        res = res.pow(v1.intValueExact());
                    }
                }
                continue;
            }
            catch (ArithmeticException ex) {
                this.setErro(true);
                return "";
            }
        }
        return res.toString();
    }

    public boolean isVariavel(String palavra) {
        return false;
    }

    public String getVarValue(String palavra) {
        return palavra;
    }
}

