/*
 * Decompiled with CFR 0.152.
 */
package controlador;

import controlador.Acao;
import controlador.Configuer;
import controlador.Diagrama;
import controlador.Editor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import util.BrLogger;
import util.TratadorDeImagens;

public class Controler {
    private final Editor editor;
    public JToggleButton BtnNothing;
    public HashMap<String, ImageIcon> ImagemDeDiagrama = new HashMap();
    public HashMap<String, Cursor> Cursores = new HashMap();
    public ArrayList<ConfigAcao> Lista = new ArrayList();
    public ArrayList<Acao> ListaDeAcoesEditaveis = new ArrayList();
    private JComponent Barra;
    public JMenu BarraMenu;
    private final HashMap<String, AbstractButton> listaBotoes = new HashMap();
    private final HashMap<String, JMenuItem> listaMenus = new HashMap();

    public Controler(Editor edt) {
        this.editor = edt;
        this.Construir();
    }

    public Cursor MakeCursor(Comandos comando) {
        Cursor cur;
        String key = comando.name().substring(3);
        if (this.Cursores.containsKey(key)) {
            return this.Cursores.get(key);
        }
        try {
            Toolkit kit = Toolkit.getDefaultToolkit();
            Dimension dim = kit.getBestCursorSize(24, 24);
            BufferedImage buffered = new BufferedImage(dim.width, dim.height, 2);
            Graphics2D g = buffered.createGraphics();
            RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.addRenderingHints(renderHints);
            g.setColor(Color.GRAY);
            GeneralPath dr = new GeneralPath(0, 3);
            dr.moveTo(0.0f, 0.0f);
            dr.lineTo(10.0f, 0.0f);
            dr.lineTo(0.0f, 10.0f);
            g.fill(dr);
            g.setColor(Color.BLACK);
            dr = new GeneralPath(0, 3);
            dr.moveTo(2.0f, 2.0f);
            dr.lineTo(8.0f, 2.0f);
            dr.lineTo(2.0f, 8.0f);
            g.fill(dr);
            Image img = this.getImagem(key).getImage();
            g.drawImage(img, 9, 9, null);
            g.dispose();
            cur = kit.createCustomCursor(buffered, new Point(1, 1), key);
        }
        catch (HeadlessException | IndexOutOfBoundsException e) {
            BrLogger.Logger("Cursor: " + key, e.toString());
            return new Cursor(0);
        }
        this.Cursores.put(key, cur);
        return cur;
    }

    public final void Construir() {
        String str;
        ResourceBundle resourceMap = Configuer.getResourceMap();
        for (Comandos comandos : Comandos.values()) {
            str = "diagrama." + comandos.toString().substring(3);
            this.Lista.add(new ConfigAcao(resourceMap.getString(str), str + ".img", str + ".descricao", comandos.toString(), TipoConfigAcao.tpAny));
        }
        for (Enum enum_ : menuComandos.values()) {
            str = "Controler.comandos." + enum_.toString().substring(3).toLowerCase();
            this.Lista.add(new ConfigAcao(Editor.fromConfiguracao.getValor(str + ".descricao"), str + ".img", str + ".descricao", enum_.toString(), TipoConfigAcao.tpMenus));
        }
        for (Enum enum_ : Diagrama.TipoDeDiagrama.values()) {
            this.ImagemDeDiagrama.put(enum_.name(), TratadorDeImagens.loadFromResource("Controler.interface.Diagrama.Icone." + enum_.name().substring(2), true));
        }
        this.ImagemDeDiagrama.put("Controler.interface.mostrador.fechar.img", TratadorDeImagens.loadFromResource("Controler.interface.mostrador.fechar.img", true));
        this.ImagemDeDiagrama.put("diagrama.Campo_Key.img", TratadorDeImagens.loadFromResource("diagrama.Campo_Key.img", true));
        this.ImagemDeDiagrama.put("diagrama.Campo_Fkey.img", TratadorDeImagens.loadFromResource("diagrama.Campo_Fkey.img", true));
        this.ImagemDeDiagrama.put("diagrama.Campo_KeyFkey.img", TratadorDeImagens.loadFromResource("diagrama.Campo_KeyFkey.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.0.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.0.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.1.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.1.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.0.0.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.0.0.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.2.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.2.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.3.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.3.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.4.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.4.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.5.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.5.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.6.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.6.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.7.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.7.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.8.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.8.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.9.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.9.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.7.0.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.7.0.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.8.0.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.8.0.img", true));
        this.ImagemDeDiagrama.put("diagrama.ancordor.9.0.img", TratadorDeImagens.loadFromResource("diagrama.ancordor.9.0.img", true));
        this.ImagemDeDiagrama.put("diagrama.Constraint_PK.img", TratadorDeImagens.loadFromResource("diagrama.Constraint_PK.img", true));
        this.ImagemDeDiagrama.put("diagrama.Constraint_FK.img", TratadorDeImagens.loadFromResource("diagrama.Constraint_FK.img", true));
        this.ImagemDeDiagrama.put("diagrama.Constraint_UN.img", TratadorDeImagens.loadFromResource("diagrama.Constraint_UN.img", true));
        this.ImagemDeDiagrama.put("diagrama.Constraint_UNFK.img", TratadorDeImagens.loadFromResource("diagrama.Constraint_UNFK.img", true));
        this.ImagemDeDiagrama.put("diagrama.Constraint_see.img", TratadorDeImagens.loadFromResource("diagrama.Constraint_see.img", true));
        this.ImagemDeDiagrama.put("Controler.interface.ajuda.icone", TratadorDeImagens.loadFromResource("Controler.interface.ajuda.icone", true));
    }

    public void PopuleBarra(JComponent obj) {
        ButtonGroup buttons = new ButtonGroup();
        this.Barra = obj;
        Acao ac = new Acao(this.editor, "?", "Controler.interface.BarraLateral.Nothing.img", "Controler.interface.BarraLateral.Nothing.Texto", null);
        JToggleButton btn = this.arrume(new JToggleButton(ac));
        buttons.add(btn);
        obj.add(btn);
        btn.setSelected(true);
        ac.IDX = -1;
        this.BtnNothing = btn;
        int i = 0;
        for (ConfigAcao ca : this.Lista) {
            if (ca.tipo != TipoConfigAcao.tpBotoes && ca.tipo != TipoConfigAcao.tpAny) continue;
            ac = new Acao(this.editor, ca.texto, ca.ico, ca.descricao, ca.command);
            ac.IDX = i++;
            btn = this.arrume(new JToggleButton(ac));
            buttons.add(btn);
            this.listaBotoes.put(ca.command, btn);
        }
        menuComandos c = menuComandos.cmdDel;
        String str = "Controler.comandos." + c.toString().substring(3).toLowerCase();
        ac = new Acao(this.editor, Editor.fromConfiguracao.getValor(str + ".descricao"), str + ".img", str + ".descricao", c.toString());
        this.ListaDeAcoesEditaveis.add(ac);
        ac.normal = false;
        JButton btn2 = new JButton(ac);
        btn2.setHideActionText(true);
        btn2.setFocusable(false);
        btn2.setPreferredSize(new Dimension(40, 40));
        obj.add(btn2);
        LayoutManager la = obj.getLayout();
        if (la instanceof GridLayout) {
            ((GridLayout)la).setRows(i + 2);
        }
    }

    private JToggleButton arrume(JToggleButton btn) {
        Dimension btnDim = new Dimension(40, 40);
        btn.setHideActionText(true);
        btn.setFocusable(false);
        btn.setPreferredSize(btnDim);
        btn.setDoubleBuffered(true);
        btn.setRolloverEnabled(false);
        return btn;
    }

    public void PopuleBarra(JMenu obj) {
        int i = 0;
        for (ConfigAcao ca : this.Lista) {
            if (ca.tipo != TipoConfigAcao.tpMenuBarra && ca.tipo != TipoConfigAcao.tpAny) continue;
            Acao ac = new Acao(this.editor, ca.texto, ca.ico, ca.descricao, ca.command);
            ac.IDX = i++;
            JMenuItem mi = new JMenuItem(ac);
            this.listaMenus.put(ca.command, mi);
        }
        obj.setText(Editor.fromConfiguracao.getValor("Controler.interface.menu.menuDiagrama.texto"));
        char b = Editor.fromConfiguracao.getValor("Controler.interface.menu.menuDiagrama.mtecla").charAt(0);
        obj.setMnemonic(b);
        this.BarraMenu = obj;
    }

    public void PopuleMenus(JMenu menuEditar, JMenu menuArquivo, JPopupMenu popup) {
        int i = 0;
        ArrayList<String> forMEdt = new ArrayList<String>();
        forMEdt.add(menuComandos.cmdUndo.toString());
        forMEdt.add(menuComandos.cmdRendo.toString());
        forMEdt.add(menuComandos.cmdCut.toString());
        forMEdt.add(menuComandos.cmdCopy.toString());
        forMEdt.add(menuComandos.cmdCopyImg.toString());
        forMEdt.add(menuComandos.cmdPaste.toString());
        forMEdt.add(menuComandos.cmdCopyFormat.toString());
        forMEdt.add(menuComandos.cmdPasteFormat.toString());
        forMEdt.add(menuComandos.cmdRealcar.toString());
        forMEdt.add(menuComandos.cmdSelProx.toString());
        forMEdt.add(menuComandos.cmdSelAnt.toString());
        forMEdt.add(menuComandos.cmdSelectAll.toString());
        forMEdt.add(menuComandos.cmdBringToFront.toString());
        forMEdt.add(menuComandos.cmdSendToBack.toString());
        forMEdt.add(menuComandos.cmdDel.toString());
        ArrayList<String> forMArq = new ArrayList<String>();
        forMArq.add(menuComandos.cmdNew.toString());
        forMArq.add(menuComandos.cmdOpen.toString());
        forMArq.add(menuComandos.cmdClose.toString());
        forMArq.add(menuComandos.cmdPrint.toString());
        forMArq.add(menuComandos.cmdExport.toString());
        forMArq.add(menuComandos.cmdSave.toString());
        forMArq.add(menuComandos.cmdSaveAs.toString());
        forMArq.add(menuComandos.cmdSaveAll.toString());
        String[] btns = new String[]{menuComandos.cmdMicroAjuste0.toString(), menuComandos.cmdMicroAjuste1.toString(), menuComandos.cmdMicroAjuste2.toString(), menuComandos.cmdMicroAjuste3.toString(), menuComandos.cmdDimPastLeft.toString(), menuComandos.cmdDimPastTop.toString(), menuComandos.cmdDimPastRight.toString(), menuComandos.cmdDimPastBottom.toString(), menuComandos.cmdDimPastWidth.toString(), menuComandos.cmdDimPastHeight.toString(), menuComandos.cmdDimAlignH.toString(), menuComandos.cmdDimAlignV.toString()};
        ArrayList<String> justBtns = new ArrayList<String>();
        justBtns.addAll(Arrays.asList(btns));
        for (ConfigAcao ca : this.Lista) {
            char a;
            KeyStroke k;
            String str;
            Acao ac;
            boolean medt;
            boolean bl = medt = forMEdt.indexOf(ca.command) > -1;
            if (medt || forMArq.indexOf(ca.command) > -1) {
                ac = new Acao(this.editor, ca.texto, ca.ico, ca.descricao, ca.command);
                ac.IDX = -1;
                ac.normal = false;
                str = "Controler.comandos." + ca.command.substring(3).toLowerCase() + ".tecla";
                k = KeyStroke.getKeyStroke(Editor.fromConfiguracao.getValor(str));
                ac.putValue("AcceleratorKey", k);
                a = Editor.fromConfiguracao.getValor("Controler.comandos." + ca.command.substring(3).toLowerCase() + ".mtecla").charAt(0);
                ac.putValue("MnemonicKey", KeyEvent.getExtendedKeyCodeForChar(a));
                JMenuItem mi = new JMenuItem(ac);
                if (medt) {
                    if (++i == 4 || i == 9 || i == 10 || i == 16) {
                        menuEditar.addSeparator();
                        popup.addSeparator();
                    }
                    menuEditar.add(mi);
                    popup.add(new JMenuItem(ac));
                    this.ListaDeAcoesEditaveis.add(ac);
                    continue;
                }
                if (menuComandos.cmdNew.toString().equals(ca.command)) {
                    JMenu men = new JMenu(ac);
                    men.setText(ca.texto);
                    for (Diagrama.TipoDeDiagrama tp : Diagrama.TipoDeDiagrama.values()) {
                        String tmp = Editor.fromConfiguracao.getValor("Inspector.lst.tipodiagrama." + tp.name().substring(2).toLowerCase());
                        ac = new Acao(this.editor, tmp, "Controler.interface.Diagrama.Icone." + tp.name().substring(2), tmp, ca.command);
                        ac.IDX = -1;
                        ac.normal = false;
                        str = "Controler.comandos." + tp.name().substring(2).toLowerCase() + ".tecla";
                        k = KeyStroke.getKeyStroke(Editor.fromConfiguracao.getValor(str));
                        ac.putValue("AcceleratorKey", k);
                        a = Editor.fromConfiguracao.getValor("Controler.comandos." + tp.name().substring(2).toLowerCase() + ".mtecla").charAt(0);
                        ac.putValue("MnemonicKey", KeyEvent.getExtendedKeyCodeForChar(a));
                        mi = new JMenuItem(ac);
                        mi.setName(tp.name());
                        men.add(mi);
                    }
                    menuArquivo.add(men);
                } else {
                    menuArquivo.add(mi);
                }
                if (!menuComandos.cmdSaveAll.toString().equals(ca.command) && !menuComandos.cmdSave.toString().equals(ca.command) && !menuComandos.cmdExport.toString().equals(ca.command)) continue;
                this.ListaDeAcoesEditaveis.add(ac);
                continue;
            }
            if (justBtns.indexOf(ca.command) <= -1) continue;
            ac = new Acao(this.editor, ca.texto, ca.ico, ca.descricao, ca.command);
            ac.IDX = -1;
            ac.normal = false;
            str = "Controler.comandos." + ca.command.substring(3).toLowerCase() + ".tecla";
            k = KeyStroke.getKeyStroke(Editor.fromConfiguracao.getValor(str));
            ac.putValue("AcceleratorKey", k);
            a = Editor.fromConfiguracao.getValor("Controler.comandos." + ca.command.substring(3).toLowerCase() + ".mtecla").charAt(0);
            ac.putValue("MnemonicKey", KeyEvent.getExtendedKeyCodeForChar(a));
            this.ListaDeAcoesEditaveis.add(ac);
        }
        JMenuItem quit = menuArquivo.getItem(0);
        menuArquivo.remove(quit);
        Action ac = quit.getAction();
        KeyStroke k = KeyStroke.getKeyStroke(Editor.fromConfiguracao.getValor("Controler.interface.menu.quit.tecla"));
        ac.putValue("AcceleratorKey", k);
        ac.putValue("ShortDescription", Editor.fromConfiguracao.getValor("Controler.interface.menu.quit.texto"));
        ac.putValue("Name", Editor.fromConfiguracao.getValor("Controler.interface.menu.quit.texto"));
        char a = Editor.fromConfiguracao.getValor("Controler.interface.menu.quit.mtecla").charAt(0);
        ac.putValue("MnemonicKey", KeyEvent.getExtendedKeyCodeForChar(a));
        menuArquivo.add(new JSeparator());
        menuArquivo.add(quit);
        menuEditar.setText(Editor.fromConfiguracao.getValor("Controler.interface.menu.menuEditar.texto"));
        char b = Editor.fromConfiguracao.getValor("Controler.interface.menu.menuEditar.mtecla").charAt(0);
        menuEditar.setMnemonic(b);
        menuArquivo.setText(Editor.fromConfiguracao.getValor("Controler.interface.menu.fileMenu.texto"));
        b = Editor.fromConfiguracao.getValor("Controler.interface.menu.fileMenu.mtecla").charAt(0);
        menuArquivo.setMnemonic(b);
        this.makeEnableComands();
    }

    public void SelecioneForAction(Acao ac) {
        if (this.Barra == null) {
            return;
        }
        for (Component c : this.Barra.getComponents()) {
            JToggleButton btn;
            Action tmp;
            if (!(c instanceof JToggleButton) || !((tmp = (btn = (JToggleButton)c).getAction()) instanceof Acao) || ((Acao)tmp).IDX != ac.IDX) continue;
            btn.setSelected(true);
        }
    }

    public void makeEnableComands() {
        boolean alll = this.editor.diagramaAtual == null;
        for (Acao ac : this.ListaDeAcoesEditaveis) {
            if (alll) {
                ac.setEnabled(false);
                continue;
            }
            String cmd = ac.getValue("ActionCommandKey").toString();
            if (cmd.equals(Comandos.cmdApagar.toString())) {
                ac.setEnabled(this.editor.diagramaAtual.getListaDeItens().size() > 1);
                continue;
            }
            menuComandos comm = menuComandos.valueOf(cmd);
            switch (comm) {
                case cmdUndo: {
                    ac.setEnabled(this.editor.podeDesfazer());
                    break;
                }
                case cmdRendo: {
                    ac.setEnabled(this.editor.podeRefazer());
                    break;
                }
                case cmdCut: 
                case cmdCopy: 
                case cmdCopyImg: 
                case cmdDel: 
                case cmdCopyFormat: 
                case cmdMicroAjuste0: 
                case cmdMicroAjuste1: 
                case cmdMicroAjuste2: 
                case cmdMicroAjuste3: {
                    ac.setEnabled(this.editor.diagramaAtual.TemSelecionado());
                    break;
                }
                case cmdRealcar: {
                    if (!this.editor.diagramaAtual.isRealce()) {
                        ac.setEnabled(this.editor.diagramaAtual.TemSelecionado());
                        ac.Renomeie("Controler.comandos.realcar.descricao");
                        break;
                    }
                    ac.setEnabled(true);
                    ac.Renomeie("Controler.comandos.realcar.descricao.b");
                    break;
                }
                case cmdSelProx: 
                case cmdSelAnt: 
                case cmdBringToFront: 
                case cmdSendToBack: {
                    int tl = this.editor.diagramaAtual.getItensSelecionados().size();
                    ac.setEnabled(tl == 1);
                    break;
                }
                case cmdSelectAll: 
                case cmdExport: {
                    ac.setEnabled(this.editor.diagramaAtual.getListaDeItens().size() > 1);
                    break;
                }
                case cmdDimPastLeft: 
                case cmdDimPastTop: 
                case cmdDimPastRight: 
                case cmdDimPastBottom: 
                case cmdDimPastWidth: 
                case cmdDimPastHeight: 
                case cmdDimAlignH: 
                case cmdDimAlignV: {
                    ac.setEnabled(this.editor.diagramaAtual.getItensSelecionados().size() > 1);
                    break;
                }
                case cmdPasteFormat: {
                    ac.setEnabled(this.editor.diagramaAtual.TemSelecionado() && this.editor.CopiadorFormatacao.isCopiado());
                    break;
                }
                case cmdSaveAll: {
                    ac.setEnabled(this.editor.getDiagramas().stream().anyMatch(d -> d.getMudou()));
                    break;
                }
                case cmdSave: {
                    ac.setEnabled(this.editor.diagramaAtual.getMudou());
                }
            }
        }
    }

    public void AjusteBarra(ArrayList<String> comm) {
        int i = 0;
        for (Comandos k : Comandos.values()) {
            String ks = k.name();
            if (comm.indexOf(ks) > -1) {
                this.Barra.add(this.listaBotoes.get(ks));
                ++i;
                continue;
            }
            this.Barra.remove(this.listaBotoes.get(ks));
        }
        Component bkp = this.Barra.getComponent(1);
        this.Barra.remove(bkp);
        this.Barra.add(bkp);
        LayoutManager la = this.Barra.getLayout();
        if (la instanceof GridLayout) {
            ((GridLayout)la).setRows(i + 2);
        }
        this.Barra.revalidate();
        for (Comandos k : Comandos.values()) {
            String ks = k.name();
            if (comm.indexOf(ks) > -1) {
                this.BarraMenu.add(this.listaMenus.get(ks));
                continue;
            }
            this.BarraMenu.remove(this.listaMenus.get(ks));
        }
        this.BarraMenu.revalidate();
    }

    public ImageIcon getImagem(String path) {
        String caminhoCompleto = "diagrama." + path + ".img";
        if (this.ImagemDeDiagrama.containsKey(path)) {
            return this.ImagemDeDiagrama.get(path);
        }
        ImageIcon img = null;
        try {
            Image imgx = Configuer.getImageFromResource(caminhoCompleto);
            if (imgx != null) {
                imgx = imgx.getScaledInstance(16, 16, 4);
                img = new ImageIcon(imgx);
            }
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_GET_RESOURCE_IMG", e.getMessage());
            return null;
        }
        if (img != null) {
            this.ImagemDeDiagrama.put(path, img);
        }
        return img;
    }

    public ImageIcon getImagemNormal(String path) {
        String caminhoCompleto = "diagrama." + path + ".img";
        if (this.ImagemDeDiagrama.containsKey("N" + path)) {
            return this.ImagemDeDiagrama.get("N" + path);
        }
        ImageIcon img = null;
        try {
            Image imgx = Configuer.getImageFromResource(caminhoCompleto);
            img = new ImageIcon(imgx);
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_GET_RESOURCE_IMG", e.getMessage());
            return null;
        }
        this.ImagemDeDiagrama.put("N" + path, img);
        return img;
    }

    public class ConfigAcao {
        private final String texto;
        private final String ico;
        private final String descricao;
        private final String command;
        private final TipoConfigAcao tipo;

        public ConfigAcao(String texto, String ico, String descricao, String command, TipoConfigAcao tipo) {
            this.texto = texto;
            this.ico = ico;
            this.descricao = descricao;
            this.command = command;
            this.tipo = tipo;
        }
    }

    public static enum TipoConfigAcao {
        tpBotoes,
        tpMenuBarra,
        tpAny,
        tpMenus;

    }

    public static enum menuComandos {
        cmdUndo,
        cmdRendo,
        cmdCut,
        cmdCopy,
        cmdCopyImg,
        cmdPaste,
        cmdCopyFormat,
        cmdPasteFormat,
        cmdRealcar,
        cmdSelProx,
        cmdSelAnt,
        cmdSelectAll,
        cmdBringToFront,
        cmdSendToBack,
        cmdDel,
        cmdDelToSel,
        cmdNew,
        cmdOpen,
        cmdClose,
        cmdPrint,
        cmdExport,
        cmdSave,
        cmdSaveAs,
        cmdSaveAll,
        cmdTreeNavegador,
        cmdTreeSelect,
        cmdMicroAjuste0,
        cmdMicroAjuste1,
        cmdMicroAjuste2,
        cmdMicroAjuste3,
        cmdDimPastLeft,
        cmdDimPastTop,
        cmdDimPastRight,
        cmdDimPastBottom,
        cmdDimPastWidth,
        cmdDimPastHeight,
        cmdDimAlignH,
        cmdDimAlignV;

    }

    public static enum Comandos {
        cmdEntidade,
        cmdRelacionamento,
        cmdAutoRelacionamento,
        cmdEspecializacao,
        cmdEspecializacao_Exclusiva,
        cmdEspecializacao_Dupla,
        cmdUniao,
        cmdUniao_Entidades,
        cmdEntidadeAssociativa,
        cmdAtributo,
        cmdAtributo_Multivalorado,
        cmdLinha,
        cmdTabela,
        cmdCampo,
        cmdCampo_Key,
        cmdCampo_Fkey,
        cmdCampo_KeyFkey,
        cmdLogicoLinha,
        cmdInicioAtividade,
        cmdEstadoAtividade,
        cmdDecisaoAtividade,
        cmdFimAtividade,
        cmdSetaAtividade,
        cmdLigacaoAtividade,
        cmdTextoAtividade,
        cmdForkJoinAtividade,
        cmdRaiaAtividade,
        cmdFluxIniFim,
        cmdFluxProcesso,
        cmdFluxConector,
        cmdFluxDecisao,
        cmdFluxDocumento,
        cmdFluxVDocumentos,
        cmdFluxNota,
        cmdFluxLigacao,
        cmdFluxSeta,
        cmdFluxTexto,
        cmdEapProcesso,
        cmdEapLigacao,
        cmdEapBarraLigacao,
        cmdLivreRetangulo,
        cmdLivreRetanguloArr,
        cmdLivreComentario,
        cmdLivreTriangulo,
        cmdLivreLigacao,
        cmdLivreLigacaoSimples,
        cmdLivreJuncao,
        cmdLivreDocumento,
        cmdLivreVariosDocumentos,
        cmdLivreNota,
        cmdLivreSuperTexto,
        cmdLivreLosango,
        cmdLivreCirculo,
        cmdLivreDrawer,
        cmdDesenhador,
        cmdTexto,
        cmdLegenda,
        cmdApagar;

    }
}

