/*
 * Decompiled with CFR 0.152.
 */
package diagramas.logico;

import controlador.Editor;
import controlador.apoios.TreeItem;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import diagramas.logico.Campo;
import diagramas.logico.LogicoLinha;
import diagramas.logico.Tabela;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.BrLogger;
import util.TratadorDeImagens;
import util.Utilidades;
import util.XMLGenerate;

public class Constraint
implements Serializable {
    private static final long serialVersionUID = 2017041120493765643L;
    private final Tabela tabela;
    public Rectangle area = null;
    protected transient boolean roqued = false;
    private final int V_MOTIVO_OK = 0;
    private final int V_MOTIVO_CONS_ORIGEM = 1;
    private final int V_MOTIVO_QTD_CMP = 2;
    private final int V_MOTIVO_TIPO = 3;
    private final int V_MOTIVO_CAMPO_REP = 4;
    private final int V_MOTIVO_NAO_LIGADO = 5;
    private final int V_MOTIVO_KEY_AND_UNIQUE = 6;
    private String[] getMotivoValidade = null;
    private int motivoValidade = 0;
    private boolean nomeada = false;
    private String nome = "";
    private final ArrayList<Campo> camposDeOrigem = new ArrayList();
    private final ArrayList<Campo> camposDeDestino = new ArrayList();
    private CONSTRAINT_TIPO tipo = CONSTRAINT_TIPO.tpPK;
    private Constraint constraintOrigem = null;
    private String observacao = "";
    private String dicionario = "";
    private boolean selecionado = false;
    private boolean validado = true;
    private transient boolean novalide = false;
    private LogicoLinha ligacao = null;
    public static final int TAG_COMMAND_PK = 120420170;
    public static final int TAG_COMMAND_FK = 120420171;
    public static final int TAG_COMMAND_UN = 120420172;
    private final int DESCE_CONSTAN = 110417;
    private final int SOBE_CONSTAN = -110417;
    private String ddlOnUpdate = "";
    private String ddlOnDelete = "";

    public Tabela getTabela() {
        return this.tabela;
    }

    public Constraint(Tabela tbl) {
        this.tabela = tbl;
        this.tabela.Add(this);
        this.getMotivoValidade = new String[]{Editor.fromConfiguracao.getValor("Inspector.obj.constraint.validacao.ok"), Editor.fromConfiguracao.getValor("Inspector.obj.constraint.validacao.cons_origem"), Editor.fromConfiguracao.getValor("Inspector.obj.constraint.validacao.qtd_cmp"), Editor.fromConfiguracao.getValor("Inspector.obj.constraint.validacao.tipo"), Editor.fromConfiguracao.getValor("Inspector.obj.constraint.validacao.rep"), Editor.fromConfiguracao.getValor("Inspector.obj.constraint.validacao.ligacao"), Editor.fromConfiguracao.getValor("Inspector.obj.constraint.validacao.ku")};
    }

    public void Paint(int x, int y, int altura, Graphics2D g) {
        ImageIcon img;
        Rectangle r;
        int f = 2 * this.getTabela().DDL_PEGAR_TUDO;
        int imgl = 16;
        this.area = r = new Rectangle(this.getTabela().getLeft() + x, this.getTabela().getTop() + y, this.getTabela().getWidth() - x - 1, altura);
        if (r.y + altura > this.getTabela().getTopHeight()) {
            return;
        }
        float alfa = 1.0f - this.getTabela().getAlfa();
        Composite originalComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, alfa));
        Paint bkpp = g.getPaint();
        g.setColor(this.getTabela().getMaster().getBackground());
        g.fill(this.area);
        if (this.isSelecionado()) {
            if (this.getTabela().isGradiente()) {
                g.setColor(this.getTabela().getGradienteStartColor());
            } else {
                g.setColor(this.getTabela().getForeColor());
            }
            g.setComposite(AlphaComposite.getInstance(3, this.getTabela().getAlfa()));
            g.fillRect(r.x, r.y, r.width + 1, r.height);
        }
        g.setPaint(bkpp);
        g.setComposite(originalComposite);
        Rectangle bkp = g.getClipBounds();
        switch (this.getTipo()) {
            case tpPK: {
                img = Editor.fromControler().ImagemDeDiagrama.get("diagrama.Constraint_PK.img");
                break;
            }
            case tpFK: {
                img = Editor.fromControler().ImagemDeDiagrama.get("diagrama.Constraint_FK.img");
                break;
            }
            default: {
                img = Editor.fromControler().ImagemDeDiagrama.get("diagrama.Constraint_UN.img");
            }
        }
        if (!this.isValidado()) {
            g.drawRoundRect(r.x - 1 + f, r.y + 4 - 1, imgl + 1, imgl + 1, 4, 4);
        }
        if (this.roqued) {
            Stroke bkps = g.getStroke();
            g.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
            g.drawRoundRect(r.x - 1 + f, r.y + 4 - 1, imgl + 1, imgl + 1, 4, 4);
            g.setStroke(bkps);
        }
        if (this.getTabela().isDisablePainted()) {
            img = new ImageIcon(TratadorDeImagens.dye(img, this.getTabela().getForeColor()));
        }
        g.drawImage(img.getImage(), r.x + f, r.y + 4, imgl, imgl, null);
        g.clipRect(r.x, r.y, r.width, r.height);
        g.setColor(this.getTabela().getForeColor());
        String tx = this.getNomeFormatado();
        g.drawString(tx, r.x + f + imgl + 2, r.y + altura / 2 + f);
        g.setClip(bkp);
        g.setPaint(bkpp);
    }

    public void Paint(int x, int y, Graphics2D g) {
        ImageIcon img;
        Rectangle r;
        int f = 3;
        int imgl = 16;
        this.area = r = new Rectangle(this.getTabela().getLeft() + x, this.getTabela().getTop() + y, this.getTabela().cmpAltura, this.getTabela().cmpAltura);
        float alfa = 1.0f - this.getTabela().getAlfa();
        Composite originalComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, alfa));
        Paint bkpp = g.getPaint();
        g.setColor(this.getTabela().getMaster().getBackground());
        g.fill(this.area);
        if (this.isSelecionado()) {
            if (this.getTabela().isGradiente()) {
                g.setColor(this.getTabela().getGradienteStartColor());
            } else {
                g.setColor(this.getTabela().getForeColor());
            }
            g.setComposite(AlphaComposite.getInstance(3, this.getTabela().getAlfa()));
            g.fillRect(r.x, r.y, r.width + 1, r.height);
        }
        g.setPaint(bkpp);
        g.setComposite(originalComposite);
        Rectangle bkp = g.getClipBounds();
        switch (this.getTipo()) {
            case tpPK: {
                img = Editor.fromControler().ImagemDeDiagrama.get("diagrama.Constraint_PK.img");
                break;
            }
            case tpFK: {
                img = Editor.fromControler().ImagemDeDiagrama.get("diagrama.Constraint_FK.img");
                break;
            }
            default: {
                img = Editor.fromControler().ImagemDeDiagrama.get("diagrama.Constraint_UN.img");
            }
        }
        if (!this.isValidado()) {
            g.drawRoundRect(r.x - 1 + f, r.y + f - 1, imgl + 1, imgl + 1, 4, 4);
        }
        if (this.roqued) {
            Stroke bkps = g.getStroke();
            g.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
            g.drawRoundRect(r.x - 1 + f, r.y + 4 - 1, imgl + 1, imgl + 1, 4, 4);
            g.setStroke(bkps);
        }
        if (this.getTabela().isDisablePainted()) {
            img = new ImageIcon(TratadorDeImagens.dye(img, this.getTabela().getForeColor()));
        }
        g.drawImage(img.getImage(), r.x + f, r.y + f, imgl, imgl, null);
        g.clipRect(r.x, r.y, r.width, r.height);
        g.setColor(this.getTabela().getForeColor());
        g.setClip(bkp);
        g.setPaint(bkpp);
    }

    public boolean isMe(Point p) {
        if (this.area == null) {
            return false;
        }
        return this.area.contains(p);
    }

    public String getCamposStr(List<Campo> lst) {
        if (lst == null || lst.isEmpty()) {
            return "()";
        }
        String cmpsD = "";
        cmpsD = lst.stream().map(cx -> (cx == null ? "[]" : (cx.getTexto().trim().isEmpty() ? "?" : cx.getTexto())) + ", ").reduce(cmpsD, String::concat);
        return "(" + cmpsD.substring(0, cmpsD.length() - 2) + ")";
    }

    public String getCamposStrCheck(List<Campo> lst) {
        if (lst == null || lst.isEmpty()) {
            return "()";
        }
        String cmpsD = "";
        cmpsD = lst.stream().map(cx -> (cx == null ? "[]" : (cx.getTexto().trim().isEmpty() ? "?" : cx.getTexto()) + (this.getOrigem((Campo)cx) == null ? "???" : "")) + ", ").reduce(cmpsD, String::concat);
        return "(" + cmpsD.substring(0, cmpsD.length() - 2) + ")";
    }

    public boolean isAutoRelacionamento() {
        return this.getTabela() != null && this.getTabela() == this.getTabelaDeOrigem();
    }

    public void Valide() {
        this.motivoValidade = 0;
        if (this.getTipo() != CONSTRAINT_TIPO.tpFK) {
            Campo cx;
            if (this.getCamposDeOrigem().size() == 1 && (cx = this.getCamposDeOrigem().get(0)).isKey() && cx.isUnique()) {
                this.motivoValidade = 6;
                this.setValidado(false);
                return;
            }
            this.setValidado(true);
            return;
        }
        if (this.getLigacao() == null && this.getTabela() != this.getTabelaDeOrigem()) {
            this.setValidado(false);
            this.motivoValidade = 5;
            return;
        }
        if (this.getConstraintOrigem() == null) {
            this.setValidado(false);
            this.motivoValidade = 1;
            return;
        }
        if (this.getConstraintOrigem().getCamposDeOrigem().size() != this.getCamposDeOrigem().size()) {
            this.setValidado(false);
            this.motivoValidade = 2;
            return;
        }
        boolean sn = true;
        for (int i = 0; i < this.getCamposDeOrigem().size(); ++i) {
            boolean bl = sn = this.getCamposDeOrigem().get(i) != null && this.getCamposDeOrigem().get(i).getTipo().equals(this.getCamposDeDestino().get(i).getTipo());
            if (sn) continue;
            this.motivoValidade = 3;
            break;
        }
        if (sn) {
            HashSet<Campo> teste = new HashSet<Campo>();
            int tl = 0;
            for (Campo c : this.getCamposDeOrigem()) {
                if (c == null) continue;
                teste.add(c);
                if (++tl == teste.size()) continue;
                sn = false;
                this.motivoValidade = 4;
                break;
            }
        }
        this.setValidado(sn);
    }

    protected void MostreSeParaExibicao(TreeItem root) {
        String img;
        switch (this.getTipo()) {
            case tpPK: {
                img = "Constraint_PK";
                break;
            }
            case tpFK: {
                img = "Constraint_FK";
                break;
            }
            default: {
                img = "Constraint_UN";
            }
        }
        root.add(new TreeItem(this.isNomeada() && !this.getNome().isEmpty() ? this.getNome() : Editor.fromConfiguracao.getValor("diagrama.Constraint.nome"), this.getTabela().getID(), "diagrama." + img + ".img"));
    }

    public Constraint getConstraintOrigem() {
        return this.constraintOrigem;
    }

    public void LigacaoDireta(Constraint constraintOrigem, LogicoLinha ligacao) {
        if (constraintOrigem == null || constraintOrigem.getTipo() == CONSTRAINT_TIPO.tpFK || this.constraintOrigem != null || this.getTipo() != CONSTRAINT_TIPO.tpFK) {
            this.setConstraintOrigem(constraintOrigem);
        } else {
            this.constraintOrigem = constraintOrigem;
            Tabela ori = this.constraintOrigem.getTabela();
            this.getTabela().PerformLigacao(ori, true);
            for (int tl = this.camposDeOrigem.size() - 1; tl > -1; --tl) {
                if (this.camposDeOrigem.get(tl) == null || this.camposDeOrigem.get(tl).getTabela() == ori) continue;
                this.camposDeOrigem.remove(tl);
                this.camposDeOrigem.add(tl, null);
            }
            this.ligacao = ligacao;
        }
    }

    public void setConstraintOrigem(Constraint constraintOrigem) {
        if (this.constraintOrigem != constraintOrigem) {
            Tabela ori;
            if (this.constraintOrigem != null) {
                ori = this.constraintOrigem.getTabela();
                this.getTabela().PerformLigacao(ori, false);
            }
            if (this.getTipo() == CONSTRAINT_TIPO.tpFK) {
                if (constraintOrigem != null && constraintOrigem.getTipo() == CONSTRAINT_TIPO.tpFK) {
                    constraintOrigem = null;
                }
                this.constraintOrigem = constraintOrigem;
                if (this.constraintOrigem != null) {
                    ori = this.constraintOrigem.getTabela();
                    this.getTabela().PerformLigacao(ori, true);
                }
                int tl = this.camposDeOrigem.size();
                this.camposDeOrigem.clear();
                for (int i = 0; i < tl; ++i) {
                    this.camposDeOrigem.add(null);
                }
                if (!this.getTabela().getMaster().isCarregando && !this.novalide) {
                    this.Valide();
                }
            }
        }
    }

    public CONSTRAINT_TIPO getTipo() {
        return this.tipo;
    }

    public void setTipo(CONSTRAINT_TIPO tipo) {
        if (this.tipo.equals((Object)tipo)) {
            return;
        }
        this.tipo = tipo;
        if (tipo == CONSTRAINT_TIPO.tpFK) {
            this.setValidado(false);
            this.motivoValidade = 1;
        }
    }

    public void SetTipo(int tpForInspector) {
        try {
            this.setTipo(CONSTRAINT_TIPO.values()[tpForInspector]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isNomeada() {
        return this.nomeada;
    }

    public void setNomeada(boolean nomeada) {
        if (this.nomeada == nomeada) {
            return;
        }
        this.nomeada = nomeada;
        this.Repaint();
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        if (this.nome.equals(nome)) {
            return;
        }
        this.nome = nome;
        this.Repaint();
    }

    public String getNomeFormatado() {
        return this.isNomeada() && !this.getNome().isEmpty() ? this.getNome() : this.getTipoStr();
    }

    public void Add(Campo origem, Campo destino, LogicoLinha lig, Constraint orig) {
        this.novalide = true;
        this.setConstraintOrigem(orig);
        this.novalide = false;
        this.Add(origem, destino, lig);
    }

    public void Add(Campo origem, Campo destino, LogicoLinha lig) {
        this.novalide = true;
        this.setLigacao(lig);
        this.novalide = false;
        this.Add(origem, destino);
    }

    public void Add(Campo origem, Campo destino) {
        if (this.getTipo() != CONSTRAINT_TIPO.tpFK) {
            int idx = this.camposDeOrigem.indexOf(origem);
            if (idx == -1) {
                this.camposDeOrigem.add(origem);
                this.camposDeDestino.add(destino);
            }
        } else {
            int idx = this.camposDeDestino.indexOf(destino);
            if (idx == -1) {
                this.camposDeOrigem.add(origem);
                this.camposDeDestino.add(destino);
            } else {
                this.camposDeOrigem.remove(idx);
                this.camposDeOrigem.add(idx, origem);
            }
            if (!this.getTabela().getMaster().isCarregando && origem != null && destino != null) {
                destino.setTipo(origem.getTipo());
            }
        }
        if (!this.getTabela().getMaster().isCarregando && !this.novalide) {
            this.Valide();
        }
    }

    public Campo getOrigem(Campo destino) {
        int idx = this.camposDeDestino.indexOf(destino);
        if (idx > -1) {
            return this.camposDeOrigem.get(idx);
        }
        return null;
    }

    public Campo getDestino(Campo origem) {
        int idx = this.camposDeOrigem.indexOf(origem);
        if (idx > -1) {
            return this.camposDeDestino.get(idx);
        }
        return null;
    }

    public List<Campo> getCamposDeOrigem() {
        return this.camposDeOrigem;
    }

    public List<Campo> getCamposDeDestino() {
        return this.camposDeDestino;
    }

    public void RemoveFromDestino(Campo cmp) {
        int idx = this.camposDeDestino.indexOf(cmp);
        if (idx > -1) {
            this.camposDeDestino.remove(idx);
            this.camposDeOrigem.remove(idx);
            this.Valide();
        }
    }

    public void RemoveFromOrigem(Campo cmp) {
        int idx = this.camposDeOrigem.indexOf(cmp);
        if (idx > -1) {
            this.camposDeDestino.remove(idx);
            this.camposDeOrigem.remove(idx);
            this.Valide();
        }
    }

    public void Clear() {
        this.camposDeDestino.clear();
        this.camposDeOrigem.clear();
    }

    public String getDicionario() {
        return this.dicionario;
    }

    public void setDicionario(String dicionario) {
        this.dicionario = dicionario;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public LogicoLinha getLigacao() {
        return this.ligacao;
    }

    public void setLigacao(LogicoLinha ligacao) {
        if (this.ligacao != ligacao) {
            this.ligacao = ligacao;
            if (!this.getTabela().getMaster().isCarregando && !this.novalide) {
                this.Valide();
            }
        }
    }

    public boolean isValidado() {
        return this.validado;
    }

    public void setValidado(boolean validado) {
        if (this.validado != validado) {
            this.validado = validado;
            this.InvalidateArea();
        }
    }

    public boolean isSelecionado() {
        return this.selecionado && this.getTabela().isSelecionado();
    }

    public void setSelecionado(boolean selecionado) {
        this.selecionado = selecionado;
    }

    protected Tabela getTabelaDeOrigem() {
        if (this.tipo == CONSTRAINT_TIPO.tpPK || this.tipo == CONSTRAINT_TIPO.tpUNIQUE) {
            return this.getTabela();
        }
        return this.getConstraintOrigem() == null ? null : this.getConstraintOrigem().getTabela();
    }

    protected Tabela getTabelaDeDestino() {
        if (this.tipo == CONSTRAINT_TIPO.tpPK || this.tipo == CONSTRAINT_TIPO.tpUNIQUE) {
            return null;
        }
        return this.getTabela();
    }

    public boolean SuperSelecionado() {
        return this.tabela.isSelecionado() && this.isSelecionado();
    }

    public void ToXmlValores(Document doc, Element root) {
        Element me = doc.createElement("Constraint");
        me.appendChild(XMLGenerate.ValorString(doc, "Nome", this.getNome()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Nomeada", this.isNomeada()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Tipo", this.getTipo().ordinal()));
        me.appendChild(XMLGenerate.ValorText(doc, "Dicionario", this.getDicionario()));
        me.appendChild(XMLGenerate.ValorText(doc, "Observacao", this.getObservacao()));
        me.appendChild(XMLGenerate.ValorText(doc, "DdlOnUpdate", this.getDdlOnUpdate()));
        me.appendChild(XMLGenerate.ValorText(doc, "DdlOnDelete", this.getDdlOnDelete()));
        me.appendChild(XMLGenerate.ValorRefFormElementar(doc, "LigacaoParaOrigem", this.getLigacao()));
        Element lig = XMLGenerate.ValorText(doc, "ConstraintOrigem", this.getConstraintOrigem() == null ? "" : this.getConstraintOrigem().getNomeFormatado());
        lig.setAttribute("ID", this.GeraCodToLocalise(this.getConstraintOrigem()));
        ArrayList cmps = new ArrayList();
        this.camposDeOrigem.stream().forEach(c -> cmps.add(c == null ? -1 : c.getIndexOnTable()));
        lig.setAttribute("CamposOrigem", Arrays.toString(cmps.toArray()));
        cmps.clear();
        this.camposDeDestino.stream().forEach(c -> cmps.add(c == null ? -1 : c.getIndexOnTable()));
        lig.setAttribute("CamposDestino", Arrays.toString(cmps.toArray()));
        me.appendChild(lig);
        root.appendChild(me);
    }

    public void LoadFromXML(Element me, boolean colando) {
        this.setObservacao(XMLGenerate.getValorTextoFrom(me, "Observacao"));
        this.setDicionario(XMLGenerate.getValorTextoFrom(me, "Dicionario"));
        this.setNome(XMLGenerate.getValorStringFrom(me, "Nome"));
        this.setDdlOnUpdate(XMLGenerate.getValorTextoFrom(me, "DdlOnUpdate"));
        this.setDdlOnDelete(XMLGenerate.getValorTextoFrom(me, "DdlOnDelete"));
        this.SetTipo(XMLGenerate.getValorIntegerFrom(me, "Tipo"));
        this.setNomeada(XMLGenerate.getValorBooleanFrom(me, "Nomeada"));
    }

    public boolean CommitXML(Element me, HashMap<Element, FormaElementar> mapa) {
        FormaElementar liga;
        Element lig = XMLGenerate.FindByNodeName(me, "ConstraintOrigem");
        String idStr = lig.getAttribute("ID");
        Constraint oric = this.LocaliseFomCod(idStr, mapa);
        if (oric != null) {
            this.setConstraintOrigem(oric);
        }
        String cmpStr = lig.getAttribute("CamposOrigem");
        Tabela ori = this.getTabelaDeOrigem();
        String[] origens = cmpStr.replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("\\s", "").split(",");
        if (this.getTipo() != CONSTRAINT_TIPO.tpFK) {
            for (String origen : origens) {
                int v = Utilidades.TryIntStr(origen, -1);
                if (v == -1) continue;
                this.Add(ori.getCampos().get(v), null);
            }
        } else {
            cmpStr = lig.getAttribute("CamposDestino");
            String[] destinos = cmpStr.replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("\\s", "").split(",");
            Tabela dest = this.getTabelaDeDestino();
            if (dest != null) {
                for (int i = 0; i < origens.length; ++i) {
                    int vo = Utilidades.TryIntStr(origens[i], -1);
                    int vd = Utilidades.TryIntStr(destinos[i], -1);
                    if (vd == -1) continue;
                    this.Add(vo == -1 || ori == null ? null : ori.getCampos().get(vo), dest.getCampos().get(vd));
                }
            }
        }
        if (!"-1".equals(idStr = (lig = XMLGenerate.FindByNodeName(me, "LigacaoParaOrigem")).getAttribute("ID")) && (liga = XMLGenerate.FindWhoHasID(idStr, mapa)) instanceof LogicoLinha) {
            this.setLigacao((LogicoLinha)liga);
        }
        this.Valide();
        return true;
    }

    public void Repaint() {
        if (this.getTabela() == null || this.area == null) {
            return;
        }
        this.getTabela().InvalidateArea();
    }

    public void InvalidateArea() {
        if (this.getTabela() == null || this.area == null) {
            return;
        }
        this.getTabela().InvalidateArea(this.area);
    }

    public boolean isFirst() {
        return this.getTabela().getConstraints().indexOf(this) == 0;
    }

    public boolean isLast() {
        int tmp = this.getTabela().getConstraints().indexOf(this) + 1;
        return tmp == this.getTabela().getConstraints().size();
    }

    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> res) {
        res.add(InspectorProperty.PropertyFactorySeparador("constraint.selecionado"));
        String relaName = "Constraint";
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("constraint.tipo", this.getTipoStr()));
        res.add(InspectorProperty.PropertyFactorySN("constraint.nomeada", relaName + ".setNomeada", this.isNomeada()).AddCondicaoForTrue(new String[]{relaName + ".setNome"}));
        res.add(InspectorProperty.PropertyFactoryTexto("constraint.nome", relaName + ".setNome", this.getNome()));
        res.add(InspectorProperty.PropertyFactoryTextoL("dicionario", relaName + ".setDicionario", this.getDicionario()));
        res.add(InspectorProperty.PropertyFactoryTextoL("observacao", relaName + ".setObservacao", this.getObservacao()));
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("constraint.validacao", this.getMotivoValidade[this.motivoValidade]));
        if (this.tipo == CONSTRAINT_TIPO.tpFK) {
            String txt = this.getTabelaDeOrigem() == null ? "[]" : this.getTabelaDeOrigem().getTexto();
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "constraint.tabelaorigem", txt).setTag(120420171));
            txt = this.getConstraintOrigem() == null ? "[]" : this.getConstraintOrigem().getNomeFormatado();
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "constraint.ir.origem", txt).setTag(120420171));
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "constraint.campos.ir", this.getCamposStr(this.getCamposDeOrigem())).setTag(120420171));
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "constraint.tabeladestino", this.getTabelaDeDestino().getTexto()).setTag(120420171));
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "constraint.campos.ir", this.getCamposStr(this.getCamposDeDestino())).setTag(120420171));
            res.add(InspectorProperty.PropertyFactoryTexto("constraint.ddlonupdate", relaName + ".setDdlOnUpdate", this.getDdlOnUpdate()));
            res.add(InspectorProperty.PropertyFactoryTexto("constraint.ddlondelete", relaName + ".setDdlOnDelete", this.getDdlOnDelete()));
        } else {
            res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("constraint.campos.ir", this.getCamposStr(this.getCamposDeOrigem())));
        }
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "tabela.edtitores").setTag(this.tipo == CONSTRAINT_TIPO.tpPK ? 120420170 : (this.tipo == CONSTRAINT_TIPO.tpUNIQUE ? 120420172 : 120420171)));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdExcluirSubItem.name()));
        if (this.getTabela().getConstraints().size() > 1) {
            res.add(InspectorProperty.PropertyFactorySeparador("tabela.constraint.posicao", false));
            if (!this.isFirst()) {
                res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "tabela.constraint.sobe").setTag(-110417));
            }
            if (!this.isLast()) {
                res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "tabela.constraint.desce").setTag(110417));
            }
        }
        return res;
    }

    public String getTipoStr() {
        String res;
        switch (this.getTipo()) {
            case tpFK: {
                res = Editor.fromConfiguracao.getValor("Inspector.obj.constraint.fkey");
                break;
            }
            case tpPK: {
                res = Editor.fromConfiguracao.getValor("Inspector.obj.constraint.key");
                break;
            }
            default: {
                res = Editor.fromConfiguracao.getValor("Inspector.obj.constraint.unique");
            }
        }
        return res;
    }

    public String getDDL() {
        String txt = "";
        String sepa = this.getTabela().getSepadorSql();
        switch (this.getTipo()) {
            case tpPK: {
                if (this.isNomeada() && !this.getNome().trim().isEmpty()) {
                    txt = "ALTER TABLE " + this.getTabela().getTexto() + " ADD CONSTRAINT " + this.getPrefixo() + this.getNome().trim() + " PRIMARY KEY " + this.getCamposStr(this.getCamposDeOrigem());
                    txt = txt + sepa;
                    break;
                }
                txt = "PRIMARY KEY " + this.getCamposStr(this.getCamposDeOrigem());
                break;
            }
            case tpUNIQUE: {
                if (this.isNomeada() && !this.getNome().trim().isEmpty()) {
                    txt = "ALTER TABLE " + this.getPrefixo() + this.getTabela().getTexto() + " ADD CONSTRAINT " + this.getNome().trim() + " UNIQUE " + this.getCamposStr(this.getCamposDeOrigem());
                    txt = txt + sepa;
                    break;
                }
                txt = "UNIQUE " + this.getCamposStr(this.getCamposDeOrigem());
                break;
            }
            case tpFK: {
                String nome = this.isNomeada() && !this.getNome().trim().isEmpty() ? this.getPrefixo() + this.getNome() : this.getPrefixo() + Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix") + this.getTabela().getTexto() + "_" + String.valueOf(this.getTabela().getConstraints().indexOf(this) + 1);
                String tmpCD = this.getCamposStr(this.getCamposDeOrigem()).replaceAll("\\[\\]", "???");
                String tmpCO = this.getCamposStrCheck(this.getCamposDeDestino());
                if (this.getConstraintOrigem() != null) {
                    if (this.getConstraintOrigem().getCamposDeOrigem().size() > this.getCamposDeOrigem().size()) {
                        tmpCO = tmpCO.substring(0, tmpCO.length() - 1) + (this.getCamposDeOrigem().size() > 0 ? ", " : "") + "???)";
                    }
                    if (this.getConstraintOrigem().getCamposDeOrigem().size() > this.getCamposDeDestino().size()) {
                        tmpCD = tmpCD.substring(0, tmpCD.length() - 1) + (this.getCamposDeDestino().size() > 0 ? ", " : "") + "???)";
                    }
                }
                txt = "ALTER TABLE " + this.getPrefixo() + this.getTabela().getTexto() + " ADD CONSTRAINT " + nome + "\nFOREIGN KEY " + tmpCO + "\n";
                txt = txt + "REFERENCES " + (this.getConstraintOrigem() == null ? "??? (???)" : this.getPrefixo() + this.getConstraintOrigem().getTabela().getTexto() + " " + tmpCD);
                if (!this.getDdlOnDelete().isEmpty() && !this.getDdlOnUpdate().isEmpty()) {
                    txt = txt + "\nON DELETE " + this.getDdlOnDelete() + " ON UPDATE " + this.getDdlOnUpdate();
                } else if (!this.getDdlOnDelete().isEmpty() || !this.getDdlOnUpdate().isEmpty()) {
                    txt = txt + "\n";
                    txt = txt + (!this.getDdlOnDelete().isEmpty() ? "ON DELETE " + this.getDdlOnDelete() : "");
                    txt = txt + (!this.getDdlOnUpdate().isEmpty() ? "ON UPDATE " + this.getDdlOnUpdate() : "");
                }
                txt = txt + sepa;
            }
        }
        return txt;
    }

    public String getPrefixo() {
        return this.getTabela().getPrefixo();
    }

    public void NotifiqueIR(Constraint cons, int msg, Campo cmp) {
    }

    public String getDdlOnDelete() {
        return this.ddlOnDelete;
    }

    public void setDdlOnDelete(String ddlOnDelete) {
        if (this.ddlOnDelete == null ? ddlOnDelete != null : !this.ddlOnDelete.equals(ddlOnDelete)) {
            this.ddlOnDelete = ddlOnDelete;
            this.Repaint();
        }
    }

    public String getDdlOnUpdate() {
        return this.ddlOnUpdate;
    }

    public void setDdlOnUpdate(String ddlOnUpdate) {
        if (this.ddlOnUpdate == null ? ddlOnUpdate != null : !this.ddlOnUpdate.equals(ddlOnUpdate)) {
            this.ddlOnUpdate = ddlOnUpdate;
            this.Repaint();
        }
    }

    public Constraint LocaliseFomCod(String cod, HashMap<Element, FormaElementar> mapa) {
        try {
            String[] cods = cod.split(",");
            if (cods[0].trim().equals("-1")) {
                return null;
            }
            FormaElementar e = XMLGenerate.FindWhoHasID(cods[0], mapa);
            if (e == null) {
                return null;
            }
            return ((Tabela)e).getConstraints().get(Integer.valueOf(cods[1].trim()));
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_DIAGRAMA_LOAD", e.getMessage());
            return null;
        }
    }

    public String GeraCodToLocalise(Constraint ori) {
        if (ori == null) {
            return "-1,-1";
        }
        return String.valueOf(ori.getTabela().getID()) + "," + String.valueOf(ori.getTabela().getConstraints().indexOf(ori));
    }

    public static enum CONSTRAINT_TIPO {
        tpPK,
        tpUNIQUE,
        tpFK;

    }
}

