/*
 * Decompiled with CFR 0.152.
 */
package desenho.preAnyDiagrama;

import controlador.Diagrama;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.formas.FormaLosangular;
import desenho.formas.FormaNaoRetangularBase;
import desenho.linhas.Linha;
import desenho.linhas.PontoDeLinha;
import desenho.preAnyDiagrama.PreAtributo;
import desenho.preAnyDiagrama.PreEntidade;
import diagramas.conceitual.Atributo;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class PreRelacionamento
extends FormaLosangular {
    private static final long serialVersionUID = -361853607881278277L;
    public final int CONST_DO_ORGATTR = 123;
    public boolean mudouAtributos = false;
    transient int lastL1 = 0;
    transient int lastL3 = 0;

    public PreRelacionamento(Diagrama modelo) {
        super(modelo);
    }

    public PreRelacionamento(Diagrama modelo, String texto) {
        super(modelo, texto);
    }

    @Override
    public ArrayList<Integer> getAncorasCode() {
        ArrayList<Integer> res = super.getAncorasCode();
        Integer[] ancorasCode = new Integer[]{2};
        res.addAll(Arrays.asList(ancorasCode));
        return res;
    }

    public boolean isAutoRelacionamento() {
        return this.AutoRelacionamento(this.getListaDeFormasLigadasNaoExclusiva(PreEntidade.class));
    }

    private boolean AutoRelacionamento(ArrayList<Forma> ligados) {
        return ligados.size() == 2 && ligados.get(0) == ligados.get(1);
    }

    @Override
    public boolean CanLiga(Forma forma, Linha lin) {
        if (forma == null) {
            return true;
        }
        if (super.CanLiga(forma, lin)) {
            if (forma instanceof PreAtributo) {
                return forma.CanLiga(this, lin);
            }
            if (forma instanceof PreEntidade) {
                ArrayList<Forma> lst = this.getListaDeFormasLigadasNaoExclusiva(PreEntidade.class);
                if (this.AutoRelacionamento(lst) || this.getPrincipal() == forma) {
                    return false;
                }
                return !(this.isSubComponente() ? lst.indexOf(forma) > -1 : lst.indexOf(forma) > -1 && lst.size() > 1);
            }
        }
        return false;
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        if (!this.isSubComponente()) {
            ArrayList<InspectorProperty> res = GP;
            res.add(InspectorProperty.PropertyFactorySeparador("entidade.orgattr"));
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "entidade.orgattr").setTag(123));
            super.CompleteGenerateProperty(GP);
        }
        return GP;
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        if (Tag == 123) {
            List pts = this.getListaDePontosLigados().stream().filter(p -> p.getDono().getOutraPonta((PontoDeLinha)p).getEm() instanceof Atributo).collect(Collectors.toList());
            Comparator comparator = (p1, p2) -> Integer.compare(p1.getLeft(), p2.getLeft());
            Collections.sort(pts, comparator.reversed());
            this.lastL1 = 0;
            this.lastL3 = 0;
            for (PontoDeLinha p3 : pts) {
                Atributo att;
                if (this.Alinhe(p3, att = (Atributo)p3.getDono().getOutraPonta(p3).getEm())) {
                    this.mudouAtributos = true;
                }
                if (!att.OrganizeAtributos()) continue;
                this.mudouAtributos = true;
            }
        }
    }

    private boolean Alinhe(PontoDeLinha p, Atributo atr) {
        if (this.getMaster().getItensSelecionados().indexOf(atr) > -1) {
            return false;
        }
        int L = p.getLado();
        int tmp = atr.getHeight() / 2;
        int disH = 20;
        int disW = 40;
        int l = 0;
        int t = 0;
        int X = 0;
        int Y = 0;
        switch (L) {
            case 0: {
                atr.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Right);
                X = this.getLeft() - disW - atr.getWidth();
                if (atr.getLeft() != X) {
                    l = atr.getLeft() - X;
                }
                Y = p.getCentro().y - tmp;
                if (atr.getTop() == Y) break;
                t = atr.getTop() - Y;
                break;
            }
            case 2: {
                atr.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Left);
                X = this.getLeftWidth() + disW;
                if (atr.getLeft() != X) {
                    l = atr.getLeft() - X;
                }
                Y = p.getCentro().y - tmp;
                if (atr.getTop() == Y) break;
                t = atr.getTop() - Y;
                break;
            }
            case 1: {
                atr.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Left);
                X = p.getCentro().x + 10;
                if (atr.getLeft() != X) {
                    l = atr.getLeft() - X;
                }
                Y = this.getTop() - disH - atr.getHeight();
                if (atr.getTop() != Y) {
                    t = atr.getTop() - Y;
                }
                if (this.lastL1 == 0) {
                    this.lastL1 = atr.getHeight() + 5;
                    break;
                }
                t += this.lastL1;
                this.lastL1 += atr.getHeight() + 5;
                break;
            }
            case 3: {
                atr.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Left);
                X = p.getCentro().x + 10;
                if (atr.getLeft() != X) {
                    l = atr.getLeft() - X;
                }
                Y = this.getTopHeight() + disH;
                if (atr.getTop() != Y) {
                    t = atr.getTop() - Y;
                }
                if (this.lastL3 == 0) {
                    this.lastL3 = atr.getHeight() + 5;
                    break;
                }
                t -= this.lastL3;
                this.lastL3 += atr.getHeight() + 5;
            }
        }
        Rectangle r = new Rectangle(l, t, 0, 0);
        atr.ReciveFormaResize(r);
        atr.Reenquadre();
        return l != 0 || t != 0;
    }

    @Override
    public void runAncorasCode(int cod) {
        super.runAncorasCode(cod);
        if (cod == 2) {
            this.DoAnyThing(123);
        }
    }

    @Override
    public String WhatDrawOnAcorador(Integer c) {
        if (c == 2) {
            return "diagrama.ancordor.2.img";
        }
        return super.WhatDrawOnAcorador(c);
    }

    public List<Atributo> getAtributos() {
        return this.getListaDePontosLigados().stream().filter(p -> p.getDono().getOutraPonta((PontoDeLinha)p).getEm() instanceof Atributo).map(p -> (Atributo)p.getDono().getOutraPonta((PontoDeLinha)p).getEm()).collect(Collectors.toList());
    }
}

