/*
 * Decompiled with CFR 0.152.
 */
package desenho.formas;

import controlador.Diagrama;
import controlador.inspector.InspectorProperty;
import desenho.formas.FormaNaoRetangularBase;
import desenho.linhas.PontoDeLinha;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.util.ArrayList;

public class FormaNaoRetangularDisformeBase
extends FormaNaoRetangularBase {
    private static final long serialVersionUID = 4979116307999403371L;
    protected Point[] reposicionePonto = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    protected int[] ptsToMove = new int[]{-1, -1, -1, -1};
    private boolean mudarParaTextoLongo = true;

    public FormaNaoRetangularDisformeBase(Diagrama modelo) {
        super(modelo);
        this.setTipo(FormaNaoRetangularBase.TipoDePontos.tp4Pontos);
    }

    public FormaNaoRetangularDisformeBase(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.setTipo(FormaNaoRetangularBase.TipoDePontos.tp4Pontos);
    }

    @Override
    public Shape getRegiao() {
        return this.Regiao;
    }

    protected boolean shouldMove(int ldo) {
        if (ldo > 3 || ldo < 0) {
            return false;
        }
        return this.ptsToMove[ldo] > -1;
    }

    protected Point getReposicionePonto(int ldo) {
        return this.reposicionePonto[ldo];
    }

    @Override
    protected void Posicione4Pontos(PontoDeLinha ponto) {
        super.Posicione4Pontos(ponto);
        if (this.shouldMove(ponto.getLado())) {
            Point p = ponto.getCentro();
            Point pM = this.getReposicionePonto(ponto.getLado());
            ponto.setCentro(p.x + pM.x, p.y + pM.y);
        }
    }

    @Override
    protected void DoPaintDoks(Graphics2D g) {
        Point[] pts = this.getPontosColaterais();
        Paint bkpP = g.getPaint();
        g.setPaint(Color.yellow);
        for (int i = 0; i < pts.length; ++i) {
            if (this.shouldMove(i)) {
                Point p = this.getReposicionePonto(i);
                g.fillRect(pts[i].x - 2 + p.x, pts[i].y - 2 + p.y, 4, 4);
                continue;
            }
            g.fillRect(pts[i].x - 2, pts[i].y - 2, 4, 4);
        }
        g.setPaint(bkpP);
    }

    public final void setMudarParaTextoLongo(boolean mudarParaTextoLongo) {
        this.mudarParaTextoLongo = mudarParaTextoLongo;
    }

    public boolean isMudarParaTextoLongo() {
        return this.mudarParaTextoLongo;
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        if (this.isMudarParaTextoLongo()) {
            InspectorProperty tmp = InspectorProperty.FindByProperty(res, "setTexto");
            tmp.ReSetCaptionFromConfig("nometexto");
            tmp.tipo = InspectorProperty.TipoDeProperty.tpTextoLongo;
        }
        return res;
    }
}

