<img src="https://avatars2.githubusercontent.com/u/2810941?v=3&s=96" alt="Google Cloud Platform logo" title="Google Cloud Platform" align="right" height="96" width="96"/>

# Google Cloud Functions Node.js Samples

[Cloud Functions][functions_docs] is a lightweight, event-based, asynchronous
compute solution that allows you to create small, single-purpose functions that
respond to Cloud events without the need to manage a server or a runtime
environment.

[functions_signup]: https://docs.google.com/a/google.com/forms/d/1WQNWPK3xdLnw4oXPT_AIVR9-gd6DLo5ZIucyxzSQ5fQ/viewform
[functions_docs]: https://cloud.google.com/functions/docs/

## Setup

1. Read [Prerequisites][prereq] and [How to run a sample][run] first.

[prereq]: ../README.md#prerequisities
[run]: ../README.md#how-to-run-a-sample

## Samples

* [Hello World](helloworld/)
* [Background](background/)
* [Callbacks](messages/)
* [Cloud Datastore](datastore/)
* [Cloud Pub/Sub](pubsub/)
* [Cloud Spanner](spanner/)
* [Dependencies](uuid/)
* [Error Reporting](errorreporting/)
* [HTTP](http/)
* [Logging & Monitoring](log/)
* [OCR (Optical Character Recognition)](ocr/)
* [SendGrid](sendgrid/)
* [Slack](slack/)

## Notes:
The samples in the `node8` directory are designed for use with Node.js `8.x.x` only. Unless otherwise noted, all other samples are designed for _both_ Node.js `6.x.x` _and_ Node.js `8.x.x`.
