<?php

namespace Alura\Doctrine\Mapping;

use Alura\Doctrine\Entity\Aluno;
use Alura\Doctrine\Entity\Curso;
use Alura\Doctrine\Entity\Telefone;
use Alura\Doctrine\Repository\AlunoRepository;
use LaravelDoctrine\Fluent\EntityMapping;
use LaravelDoctrine\Fluent\Fluent;

class AlunoMapping extends EntityMapping
{
    public function mapFor(): string
    {
        return Aluno::class;
    }

    public function map(Fluent $builder)
    {
        $builder
            ->entity()
            ->setRepositoryClass(AlunoRepository::class);
        $builder->increments('id');
        $builder->string('nome');
        $builder
            ->oneToMany(Telefone::class, 'telefones')
            ->mappedBy('aluno')
            ->cascadePersist()
            ->cascadeRemove()
            ->fetchEager();
        $builder
            ->manyToMany(Curso::class, 'cursos')
            ->mappedBy('alunos');
    }
}
