import { Component, Input, OnChanges, SimpleChanges } from '@angular/core';

import { Photo } from './../../photo/photo.model';

@Component({
  selector: 'app-photos',
  templateUrl: './photos.component.html',
  styleUrls: ['./photos.component.css']
})
export class PhotosComponent implements OnChanges {
  @Input()
  photos: Photo[];

  rows: any[] = [];

  constructor() {}

  ngOnChanges(changes: SimpleChanges) {
    if (changes.photos && this.photos) {
      this.rows = this.groupColumns(this.photos);
    } else {
      this.photos = [];
      this.rows = [];
    }
  }

  private groupColumns(photos: Photo[]) {
    const newRows = [];

    for (let index = 0; index < photos.length; index += 3) {
      newRows.push(photos.slice(index, index + 3));
    }

    return newRows;
  }
}
