/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.staccato.Instruction;
import org.staccato.Preprocessor;
import org.staccato.StaccatoParserContext;

public class InstructionPreprocessor
implements Preprocessor {
    private static InstructionPreprocessor instance;
    private static Pattern keyPattern;
    private Map<String, Instruction> instructions = new HashMap<String, Instruction>();

    public static InstructionPreprocessor getInstance() {
        if (instance == null) {
            instance = new InstructionPreprocessor();
        }
        return instance;
    }

    private InstructionPreprocessor() {
    }

    public void addInstruction(String key, Instruction value) {
        this.instructions.put(key, value);
    }

    public void addInstruction(String key, PatternProducer value) {
        this.addInstruction(key, value.getPattern().toString());
    }

    public void addInstruction(String key, final String value) {
        this.instructions.put(key, new Instruction(){

            @Override
            public String onInstructionReceived(String[] instructions) {
                return value;
            }
        });
    }

    @Override
    public String preprocess(String s, StaccatoParserContext context) {
        StringBuilder buddy = new StringBuilder();
        int posPrev = 0;
        String[] sizeSortedInstructions = new String[this.instructions.size()];
        Arrays.sort(this.instructions.keySet().toArray(sizeSortedInstructions), new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1.length() < s2.length()) {
                    return 1;
                }
                if (s1.length() > s2.length()) {
                    return -1;
                }
                return 0;
            }
        });
        boolean matchFound = false;
        Matcher m = keyPattern.matcher(s);
        while (m.find()) {
            String key = m.group();
            key = key.substring(1, key.length() - 1);
            for (String possibleMatch : sizeSortedInstructions) {
                if (matchFound || !key.startsWith(possibleMatch)) continue;
                Instruction instruction = this.instructions.get(possibleMatch);
                String value = key;
                if (instruction != null) {
                    value = instruction.onInstructionReceived(key.split(" "));
                }
                buddy.append(s.substring(posPrev, m.start()));
                buddy.append(value);
                posPrev = m.end();
                matchFound = true;
            }
            if (matchFound) continue;
            posPrev = m.end();
        }
        buddy.append(s.substring(posPrev, s.length()));
        return buddy.toString();
    }

    static {
        keyPattern = Pattern.compile("\\{\\p{ASCII}*?\\}");
    }
}

