/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.pattern;

import java.util.ArrayList;
import java.util.List;
import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.rhythm.Rhythm;

public class TrackTable
implements PatternProducer {
    private int length;
    private double cellDuration;
    private List<List<PatternProducer>> tracks;
    private List<PatternProducer> trackSettings;
    public static final int NUM_TRACKS = 16;
    public static final int RHYTHM_TRACK = 9;

    public TrackTable(int length, double cellDuration) {
        this.length = length;
        this.cellDuration = cellDuration;
        this.tracks = new ArrayList<List<PatternProducer>>(16);
        this.trackSettings = new ArrayList<PatternProducer>(16);
        for (int i = 0; i < 16; ++i) {
            this.trackSettings.add(new Pattern(""));
            ArrayList<Pattern> list = new ArrayList<Pattern>(length);
            for (int u = 0; u < length; ++u) {
                list.add(new Pattern("R/" + cellDuration));
            }
            this.tracks.add(list);
        }
    }

    public List<PatternProducer> getTrack(int track) {
        return this.tracks.get(track);
    }

    public TrackTable put(int track, int position, PatternProducer patternProducer) {
        List<PatternProducer> trackList = this.tracks.get(track);
        if (trackList == null) {
            trackList = new ArrayList<PatternProducer>(this.getLength());
            this.tracks.add(track, trackList);
        }
        trackList.add(position, patternProducer.getPattern());
        return this;
    }

    public TrackTable put(int track, int start, PatternProducer ... patternProducers) {
        int counter = 0;
        for (PatternProducer producer : patternProducers) {
            this.put(track, start + counter, producer);
            ++counter;
        }
        return this;
    }

    public TrackTable putAtIntervals(int track, int nth, PatternProducer patternProducer) {
        for (int position = 0; position < this.length; position += nth) {
            this.put(track, position, patternProducer);
        }
        return this;
    }

    public TrackTable putAtIntervals(int track, int first, int nth, int end, PatternProducer patternProducer) {
        for (int position = first; position < Math.min(this.length, end); position += nth) {
            this.put(track, position, patternProducer);
        }
        return this;
    }

    public TrackTable put(int track, int start, int end, PatternProducer patternProducer) {
        for (int i = start; i <= end; ++i) {
            this.put(track, i, patternProducer);
        }
        return this;
    }

    public TrackTable put(int track, String periodMeansNo_DashMeansExtend_OtherMeansYes, PatternProducer patternProducer) {
        for (int i = 0; i < periodMeansNo_DashMeansExtend_OtherMeansYes.length(); ++i) {
            if (periodMeansNo_DashMeansExtend_OtherMeansYes.charAt(i) == '.') continue;
            if (periodMeansNo_DashMeansExtend_OtherMeansYes.charAt(i) == '-') {
                this.put(track, i, (PatternProducer)new Pattern(""));
                continue;
            }
            this.put(track, i, patternProducer);
        }
        return this;
    }

    public TrackTable put(Rhythm rhythm) {
        for (int i = 0; i < rhythm.getLength(); ++i) {
            this.put(9, i, (PatternProducer)rhythm.getPatternAt(i));
        }
        return this;
    }

    public PatternProducer get(int track, int position) {
        return this.tracks.get(track).get(position);
    }

    public TrackTable clear(int track, int position) {
        this.put(track, position, (PatternProducer)new Pattern(""));
        return this;
    }

    public TrackTable reset(int track, int position) {
        this.put(track, position, (PatternProducer)new Pattern("R/" + this.cellDuration));
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public TrackTable setTrackSettings(int track, PatternProducer p) {
        this.trackSettings.add(track, p);
        return this;
    }

    public TrackTable setTrackSettings(int track, String s) {
        this.trackSettings.add(track, new Pattern(s));
        return this;
    }

    public PatternProducer getTrackSettings(int track) {
        return this.trackSettings.get(track);
    }

    public Pattern getPatternAt(int column) {
        Pattern columnPattern = new Pattern();
        for (List<PatternProducer> track : this.tracks) {
            PatternProducer p = track.get(column);
            columnPattern.add(new Pattern(p).setVoice(this.tracks.indexOf(track)));
        }
        return columnPattern;
    }

    @Override
    public Pattern getPattern() {
        Pattern pattern = new Pattern();
        int trackCounter = 0;
        for (PatternProducer patternProducer : this.trackSettings) {
            if (!patternProducer.toString().equals("")) {
                pattern.add(new Pattern(patternProducer).setVoice(trackCounter));
            }
            ++trackCounter;
        }
        for (List list : this.tracks) {
            for (PatternProducer p : list) {
                pattern.add(new Pattern(p).setVoice(this.tracks.indexOf(list)));
            }
        }
        return pattern;
    }

    public String toString() {
        return this.getPattern().toString();
    }
}

