# Getting Started with Functional Programming in PHP
A collection of resources to introduce functional programming for PHP programmers. Please see [CONTRIBUTING](CONTRIBUTING.md) for details and contribute. ;)

- [Tutorials](#tutorials)
- [Videos](#videos)
- [Slides](#slides)
- [Libraries](#libraries)
- [Other Languages](#other-languages)
- [People](#people)

## Tutorials
*Functional programming tutorials in PHP.*

* [Paradigm Soup by Anthony Ferrara](http://blog.ircmaxell.com/2012/11/programming-with-anthony-paradigm-soup.html) - Tutorial that explains the difference between programming paradigms.
* [Functional Programming in PHP by PHP The Right Way](http://www.phptherightway.com/pages/Functional-Programming.html) - Section about functional programming in PHP The Right Way.
* [Functional Programming in PHP by Tuts Plus](http://code.tutsplus.com/tutorials/functional-programming-in-php--net-35043) - Tutorial about functional programming in PHP.
* [Functional Programming in PHP by Sitepoint](http://www.sitepoint.com/functional-programming-and-php/) - Another tutorial about functional programming in PHP.
* [Functional Programming in PHP by Liip](https://blog.liip.ch/archive/2014/11/05/functional-programming-in-php.html) - Another tutorial about functional programming in PHP.
* [What are PHP Lambdas and Closures?](http://culttt.com/2013/03/25/what-are-php-lambdas-and-closures/) - Tutorial that explains what is lambdas and closures.
* [On PHP 5.3, Lambda Functions, and Closures](http://fabien.potencier.org/article/17/on-php-5-3-lambda-functions-and-closures) - Another tutorial about lambdas and closures.
* [Currying vs Partial Application](http://allthingsphp.blogspot.com.br/2012/02/currying-vs-partial-application.html) - Tutorial that explains the difference between currying and partials.
* [Using Partial Application in PHP](http://eddmann.com/posts/using-partial-application-in-php/) - Tutorial about partial functions in PHP.
* [Memoization or function cache](https://www.simonholywell.com/post/2015/05/memoization-or-function-cache/) - Tutorial about memoization in PHP.
* [Taking Monads to OOP PHP](http://blog.ircmaxell.com/2013/07/taking-monads-to-oop-php.html) - Tutorial about monads in PHP.
* [Functional programming with Monads in PHP](http://the-matrix.github.io/php/functional-programming-monads/) - Another tutorial about monads in PHP.
* [PHP Functions](http://php.net/manual/en/language.functions.php) - Documentation of how functions work in PHP.
* [Anonymous Functions](http://php.net/manual/en/functions.anonymous.php) - Documentation of how anonymous functions works in PHP.
* [Array Map](http://php.net/manual/en/function.array-map.php), [Array Filter](http://php.net/manual/en/function.array-filter.php) e [Array Reduce](http://php.net/manual/en/function.array-reduce.php) - Documentation about map, filter and reduce functions in PHP.
* [Type Hinting - Difference between Closure and Callable](http://stackoverflow.com/questions/29730720/php-type-hinting-difference-between-closure-and-callable) - Difference between Closure and Callable typehints in PHP.
* [Callable](http://php.net/manual/en/language.types.callable.php) and [is_callable](http://php.net/manual/en/function.is-callable.php) - Documentation about Callable typehint and is_callable function.
* [Closure Object Binding in PHP 5.4](https://www.christophh.net/2011/10/26/closure-object-binding-in-php-54/) - Tutorial about closure object binding in PHP.
* [PHP Function Objects](https://www.simonholywell.com/post/2015/04/php-function-objects/) - Tutorial about function objects in PHP.
* [Namespace PHP functions](https://www.simonholywell.com/post/2015/08/namespace-php-functions/) - Tutorial about namespaces and functions in PHP.

## Videos
*Videos about functional programming in PHP.*

* [Functional PHP by Larry Garfield](https://www.youtube.com/watch?v=M3_xnTK6-pA) - Fantastic talk about functional programming in PHP.
* [Go Mad for Monads](https://www.youtube.com/watch?v=F5fUgXFSH0Q) - Talk about monads in PHP.

## Slides
*Slides about functional programming in PHP.*

* [Functional PHP](https://www.palantir.net/presentations/phptek14-functional-php/#/) - Fantastic talk about functional programming in PHP.

## Libraries
*Libraries about functional programming in PHP and related concepts.*

* [Iter](https://github.com/nikic/iter)
* [Functional PHP](https://github.com/lstrojny/functional-php)
* [Underscore.php](https://github.com/Anahkiasen/underscore-php)
* [Underscore.php](https://github.com/brianhaveri/Underscore.php)
* [php-functional](https://github.com/widmogrod/php-functional)
* [monad-php](https://github.com/ircmaxell/monad-php)
* [Partial](https://github.com/reactphp/partial)
* [Promise](https://github.com/reactphp/promise)
* [Compose](https://github.com/igorw/compose)
* [transducers-php](https://github.com/mtdowling/transducers.php)
* [Pramda](https://github.com/kapolos/pramda)

## Other Languages
*Some fantastic functional programming languages that you should learn.*

* [Clojure](http://clojure.org/)
* [Elixir](http://elixir-lang.org/)
* [Erlang](http://www.erlang.org/)
* [F#](http://fsharp.org/)
* [Haskell](https://www.haskell.org/)
* [Lisp](https://en.wikipedia.org/wiki/Lisp_(programming_language))
* [OCaml](https://ocaml.org/)
* [Scala](http://www.scala-lang.org/)

## People
*Some fantastic and influential developers that talk about functional programming, PHP and other languages.*

* [Anthony Ferrara](https://twitter.com/ircmaxell) - Co-author of PHP Internals book and Developer Advocate for Google.
* [Benjamin Eberlei](https://twitter.com/beberlei) - Project-leader of Doctrine ORM and contributor to the Symfony2 Framework.
* [Igor Wiedler](https://twitter.com/igorwhiletrue) - Creator of Silex micro-framework and open-source contributor to projects like Symfony and Composer.
* [Joe Armstrong](https://twitter.com/joeerl) - Creator of Erlang language.
* [José Valim](https://twitter.com/josevalim) - Creator of Elixir language.
* [Larry Garfield](https://twitter.com/Crell) - PHP developer and core contributor of Drupal.
* [Lars Strojny](https://twitter.com/lstrojny) - PHP developer and creator of Functional PHP library.
* [Nikita Popov](https://twitter.com/nikita_ppv) - Co-author of PHP Internals book, open source contributor and creator of PHP Parser library.
* [Simon Holywell](https://twitter.com/Treffynnon) - Co-author of PHP Internals book, open source contributor and creator of PHP Parser library.
