<?php

namespace Tests\Feature;

use App\Helper\SerieRemover;
use App\Serie;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class SerieRemoverTest extends TestCase
{
    use RefreshDatabase;

    private $serie;

    protected function setUp(): void
    {
        parent::setUp(); // TODO: Change the autogenerated stub
        $this->serie = factory(Serie::class)->create();
    }

    public function testSerieRemoverRemoveSerieDoBanco()
    {
        $this->assertDatabaseHas('series', ['id' => $this->serie->id]);
        $remover = new SerieRemover();
        $remover->removeSerie($this->serie->id);
        $this->assertDatabaseMissing('series', ['id' => $this->serie->id]);
    }
}
