/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.jfugue.pattern.Token;
import org.staccato.ParenSpacesPreprocessor;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;
import org.staccato.Subparser;

public class LyricMarkerSubparser
implements Subparser {
    public static final char LYRIC = '\'';
    public static final char MARKER = '#';
    private static LyricMarkerSubparser instance;

    public static LyricMarkerSubparser getInstance() {
        if (instance == null) {
            instance = new LyricMarkerSubparser();
        }
        return instance;
    }

    @Override
    public boolean matches(String music) {
        return music.charAt(0) == '\'' || music.charAt(0) == '#';
    }

    @Override
    public Token.TokenType getTokenType(String tokenString) {
        if (tokenString.charAt(0) == '\'') {
            return Token.TokenType.LYRIC;
        }
        if (tokenString.charAt(0) == '#') {
            return Token.TokenType.MARKER;
        }
        return Token.TokenType.UNKNOWN_TOKEN;
    }

    @Override
    public int parse(String music, StaccatoParserContext context) {
        if (music.charAt(0) == '\'' || music.charAt(0) == '#') {
            String lyricOrMarker = null;
            int posNext = 0;
            posNext = music.charAt(1) == '(' ? StaccatoUtil.findNextOrEnd(music, ')', 0) : StaccatoUtil.findNextOrEnd(music, ' ', 0);
            lyricOrMarker = music.substring(music.charAt(1) == '(' ? 2 : 1, posNext);
            lyricOrMarker = ParenSpacesPreprocessor.unprocess(lyricOrMarker);
            if (music.charAt(0) == '\'') {
                context.getParser().fireLyricParsed(lyricOrMarker);
            } else {
                context.getParser().fireTrackBeatTimeBookmarked(lyricOrMarker);
                context.getParser().fireMarkerParsed(lyricOrMarker);
            }
            return Math.max(1, Math.min(posNext + 1, music.length()));
        }
        return 0;
    }
}

