/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.devices;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import org.jfugue.player.SequencerManager;

public class MusicTransmitterToSequence {
    private MidiDevice device;
    private boolean isInitiated;
    private Sequencer sequencer;

    public MusicTransmitterToSequence(MidiDevice device) throws MidiUnavailableException {
        this.device = device;
        this.isInitiated = false;
    }

    private void init() throws MidiUnavailableException, InvalidMidiDataException {
        if (!this.isInitiated) {
            if (!this.device.isOpen()) {
                this.device.open();
            }
            this.sequencer = SequencerManager.getInstance().getSequencer();
            this.sequencer.open();
            Transmitter transmitter = this.device.getTransmitter();
            Receiver receiver = this.sequencer.getReceiver();
            transmitter.setReceiver(receiver);
            Sequence sequence = new Sequence(0.0f, 24);
            for (int i = 0; i < 16; ++i) {
                Track track = sequence.createTrack();
                this.sequencer.recordEnable(track, i);
            }
            this.sequencer.setSequence(sequence);
            this.sequencer.setTickPosition(0L);
        }
    }

    public void startListening() throws MidiUnavailableException, InvalidMidiDataException {
        this.init();
        this.sequencer.startRecording();
    }

    public void stopListening() {
        this.sequencer.stopRecording();
        this.close();
    }

    public void listenForMillis(long millis) throws MidiUnavailableException, InvalidMidiDataException, InterruptedException {
        this.startListening();
        Thread.sleep(millis);
        this.stopListening();
    }

    public void close() {
        this.sequencer.close();
        this.device.close();
    }

    public Sequence getSequence() {
        return this.sequencer.getSequence();
    }
}

