/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import java.io.PrintStream;
import org.apache.commons.lang3.Validate;

public class LogConfig {
    private final PrintStream defaultPrintStream;
    private final boolean prettyPrintingEnabled;

    public LogConfig() {
        this(System.out, true);
    }

    public LogConfig(PrintStream defaultPrintStream, boolean prettyPrintingEnabled) {
        Validate.notNull((Object)defaultPrintStream, (String)"Stream to write logs to cannot be null", (Object[])new Object[0]);
        this.defaultPrintStream = defaultPrintStream;
        this.prettyPrintingEnabled = prettyPrintingEnabled;
    }

    public PrintStream defaultStream() {
        return this.defaultPrintStream;
    }

    public LogConfig defaultStream(PrintStream printStream) {
        return new LogConfig(printStream, true);
    }

    public boolean isPrettyPrintingEnabled() {
        return this.prettyPrintingEnabled;
    }

    public LogConfig enablePrettyPrinting(boolean shouldEnable) {
        return new LogConfig(this.defaultPrintStream, shouldEnable);
    }

    public static LogConfig logConfig() {
        return new LogConfig();
    }

    public LogConfig and() {
        return this;
    }
}

