/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.internal.assertion.AssertParameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.mime.HttpMultipartMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientConfig {
    private final Map<String, ?> httpClientParams;
    private final HttpMultipartMode httpMultipartMode;

    public HttpClientConfig() {
        this.httpClientParams = new HashMap<String, Object>(){
            {
                this.put("http.protocol.cookie-policy", "ignoreCookies");
            }
        };
        this.httpMultipartMode = HttpMultipartMode.STRICT;
    }

    private HttpClientConfig(Map<String, ?> httpClientParams, HttpMultipartMode httpMultipartMode) {
        AssertParameter.notNull(httpClientParams, "httpClientParams");
        AssertParameter.notNull(httpMultipartMode, "httpMultipartMode");
        this.httpClientParams = new HashMap(httpClientParams);
        this.httpMultipartMode = httpMultipartMode;
    }

    public HttpClientConfig(Map<String, ?> httpClientParams) {
        this(httpClientParams, HttpMultipartMode.STRICT);
    }

    public Map<String, ?> params() {
        return Collections.unmodifiableMap(this.httpClientParams);
    }

    public HttpClientConfig and() {
        return this;
    }

    public <T> HttpClientConfig setParam(String parameterName, T parameterValue) {
        AssertParameter.notNull(parameterName, "Parameter name");
        HashMap newParams = new HashMap(this.httpClientParams);
        newParams.put(parameterName, parameterValue);
        return new HttpClientConfig(newParams);
    }

    public HttpClientConfig withParams(Map<String, ?> httpClientParams) {
        return new HttpClientConfig(httpClientParams);
    }

    public HttpClientConfig setParams(Map<String, ?> httpClientParams) {
        return this.withParams(httpClientParams);
    }

    public HttpClientConfig addParams(Map<String, ?> httpClientParams) {
        AssertParameter.notNull(httpClientParams, "httpClientParams");
        HashMap newParams = new HashMap(httpClientParams);
        newParams.putAll(httpClientParams);
        return new HttpClientConfig(newParams);
    }

    public HttpClientConfig httpMultipartMode(HttpMultipartMode httpMultipartMode) {
        return new HttpClientConfig(this.httpClientParams, httpMultipartMode);
    }

    public static HttpClientConfig httpClientConfig() {
        return new HttpClientConfig();
    }

    public HttpMultipartMode httpMultipartMode() {
        return this.httpMultipartMode;
    }
}

