package br.com.alura.argentum.indicadores;

import br.com.alura.argentum.modelo.SerieTemporal;

public class MediaMovelPonderada implements Indicador {
	
	private Indicador outroIndicador = new IndicadorFechamento();
	
	public MediaMovelPonderada() {
	}
	
	public MediaMovelPonderada(Indicador outroIndicador){
		this.outroIndicador = outroIndicador;
	}
	
	@Override
	public double calcula(int posicao, SerieTemporal serie){
		double soma = 0;
		int peso = 3;
		
		for (int i = posicao; i > posicao -3 ; i--) {
			soma += outroIndicador.calcula(i, serie) * peso;
			peso--;
		}
		return soma/6;
	}
	
	@Override
	public String toString() {
		return "MMP de " + outroIndicador.toString();
	}

}
